@extends('layouts.app')
@section('content')
@include('layouts.partial.menu')
<style type="text/css">
    .post-cat a {
        color: #fff;
        display: inline-block;
        background-image: linear-gradient(50deg, #44318d, #beb1e9);
        padding: 14px 18px 12px;
        line-height: 1;
        font-size: 14px;
        -webkit-transition: all .3s ease-in-out;
        transition: all .3s ease-in-out;
        margin-bottom: 20px;
        margin-top: 20px;
    }

    .blog-post-details .img {
        height: 450px;
        width: 100%;
    }

    .text-strat {
/*        border: 1px solid #f0f0f0;*/
        box-shadow: rgba(100, 100, 111, 0.2) 0px 7px 29px 0px;
    }
    .modal-backdrop {
    z-index: -1;
    }

    h1.post-title {
        color: #2c1975 !important;
        font-size: 28px;
    }
/*    model csss*/
.fs-5 {
    font-size: 1.125rem !important;
    margin: 10px;
    border: 1px solid;
    border-radius: 50%;
    padding: 10px;
}
.share-model{
    top: 20%;
}

.btn-close{
    box-shadow: none;
    border: none;
    outline: none;
}

.modal-body .icons{
    margin: 15px 0px 20px 0px;
}

.modal-body .icons a{
    text-decoration: none;
    border: 1px solid transparent;
    width: 40px;
    height: 40px;
    border-radius: 50%;
    margin-right: 20px;
    transition: all 0.3s ease-in-out;
}

.modal-body .icons a:nth-child(1){
    color: #1877F2;
    border-color: #B7D4FB;
}

.modal-body .icons a:nth-child(1):hover{
    background-color: #1877F2;
    color: #fff;
}

.modal-body .icons a:nth-child(2){
    color: #46C1F6;
    border-color: #b6e7fc;
}

.modal-body .icons a:nth-child(2):hover{
    background-color: #46C1F6;
    color: #fff;
}

.modal-body .icons a:nth-child(3){
    color: #0088cc;
    border-color: #b3e6ff;
}

.modal-body .icons a:nth-child(3):hover{
    background-color: #0088cc;
    color: #fff;
}

.modal-body .icons a:nth-child(4){
    color: #25d366;
    border-color: #bef4d2;
}

.modal-body .icons a:nth-child(4):hover{
    background-color: #25d366;
    color: #fff;
}


.modal-body .icons a:nth-child(5){
    color: #0088cc;
    border-color: #b3e6ff;
}

.modal-body .icons a:nth-child(5):hover{
    background-color: #0088cc;
    color: #fff;
}

.modal-body .icons a:hover{
    border-color: transparent;
}

.modal-body .icons a span{
    transition: all 0.09s ease-in-out;
}

.modal-body .icons a:hover span{
    transform: scaleX(1.1);
}

.modal-body .field{
    margin: 15px 0px -5px 0px;
    height: 45px;
    border: 1px solid #dfdfdf;
    border-radius: 5px;
    padding: 0 5px;
}

.modal-body .field.active{
    border-color: #7d2ae8;
}

.field span{
    width: 50px;
    font-size: 1.1rem;
}

.field.active span{
    color: #7d2ae8;
}

.field input{
    border: none;
    outline: none;
    font-size: 0.89rem;
    width: 100%;
    height: 100%;
}

.field button{
    padding: 5px 16px;
    color: #fff;
    background: #322955;
    border: 2px solid transparent;
    border-radius: 5px;
    font-weight: 500;
}
.blue-gradient {
    z-index: -1;
}
@media (max-width: 330px) {
    .modal-body .icons a{
        margin-right: 15px;
        width: 35px;
        height: 35px;
    }
}
</style>
<div class="container-fluid text-center pt-6 pb-4 shadow border rounded blue-gradient">
    <div class="mb-4">
        <h1 class="mb-1 text-white">{{$blogdetail->title}}</h1>
        <nav class="" style="--bs-breadcrumb-divider: '>';" aria-label="breadcrumb">
            <ol class="breadcrumb justify-content-center py-1">
                <li class="breadcrumb-item"><a href="{{ url('/') }}">Blog</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{$blogdetail->title}}</li>
            </ol>
        </nav>
    </div>
</div>
<!-- main section  -->
<div class="container mt-2 border-wrap" style="margin-top: 40px">
    <div class="row sidebar-left">
        <div class="col-md-12  border-wrap p-5 text-strat mb-4">
            <div class="blog-post-details ">
                <img class="img" src="{{url('uploads/blogImages').'/'.$blogdetail->image}}" alt="...">
            </div>
            <div class="post-content">
                <div class="row category-section">
                    <div class="col-md-6">
                        <div class="post-cat">
                            <a href="">{{ $blogdetail->category }}</a>
                            <span class="date"><a href=""><i class="fa fa-calendar-alt"></i>
                                    <?php  
                 $blogdate = date('d-m-Y', strtotime($blogdetail->posted_date)); echo $blogdate;?>
                                </a>
                            </span>
                        </div>
                    </div>
                    <div class="col-md-6">
            <div class="container">
              <div class="row">
                <div class="col-xl-12 post-cat">
             <a type="button" class="text-uppercase text-white" data-bs-toggle="modal" data-bs-target="#socialShare" id="shareBtn" data-bs-placement="top" title="Share" style="float:right">
                Share <span class="fas fa-share"></span>
            </a>
            </div>
        </div>
    </div>
</div>
</div>


                <h1 class="post-title mt-4">{{$blogdetail->title}}</h1>
                <p style="font-weight: 400;">
                    <?php echo $blogdetail->description; ?>
                </p>
            </div>
        </div>
</div>
<div class="modal fade share-model" id="socialShare" tabindex="-1" aria-labelledby="myModelLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            {{-- <div class="modal-header">
                <h5 class="modal-title" id="myModelLabel">Share Modal</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div> --}}
            <div class="modal-body text-center">
                <p>Share this link via</p>
                <div class="d-flex justify-content-center align-items-center icons">                
                    <a href="http://www.facebook.com/sharer.php?u={{ url()->current() }}" target="_blank" class="fs-5 d-flex align-items-center justify-content-center">
                        <span class="fab fa-facebook-f"></span>
                    </a>                
                    <a href="http://twitter.com/share?url={{ url()->current() }}&text={{ $blogdetail->title }}" target="_blank" class="fs-5 d-flex align-items-center justify-content-center">
                        <span class="fab fa-twitter"></span>
                    </a>                
                    <a href="http://www.linkedin.com/shareArticle?mini=true&url={{ url()->current() }}" target="_blank" class="fs-5 d-flex align-items-center justify-content-center">
                        <span class="fab fa-linkedin"></span>
                    </a>
                    {{-- <a href="" class="fs-5 d-flex align-items-center justify-content-center">
                        <span class="fab fa-instagram"></span>
                    </a> 
                    <a href="#" class="fs-5 d-flex align-items-center justify-content-center">
                        <span class="fab fa-whatsapp"></span>
                    </a>                
                    <a href="#" class="fs-5 d-flex align-items-center justify-content-center">
                        <span class="fab fa-telegram-plane"></span>
                    </a> --}}
                </div>
                <p>Or copy link</p>
                <div class="field d-flex align-items-center justify-content-between">
                    <span class="fas fa-link text-center"></span>
                    <input type="text" id="copyField" value="{{ url()->current(); }}">
                    <button>Copy</button>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
<script>

    document.addEventListener('DOMContentLoaded',function(e){
            let field = document.querySelector('.field');
            let input = document.querySelector('input');
            let copyBtn = document.querySelector('.field button');

            var copyText = document.getElementById("copyField");
            copyText.select();
            copyText.setSelectionRange(0, 99999); // For mobile devices
            navigator.clipboard.writeText(copyText.value);
            copyBtn.onclick = () =>{
                input.select();
                if(document.execCommand("copy")){
                    field.classList.add('active');
                    copyBtn.innerText = 'Copied';
                    setTimeout(()=>{
                        field.classList.remove('active');
                        copyBtn.innerText = 'Copy';
                    },3500)
                }
            }
        })
</script>

@endsection