@extends('layouts.app')
@section('content')
@include('layouts.partial.menu')
<style>
	div#courseSidebar {
		position: unset!important;
	}
</style>
<div class="container-fluid text-center pt-6 pb-4 shadow border rounded blue-gradient">
   <div class="mb-4">
       <h1 class="mb-1 text-white">Our Blog</h1>
       <nav class="" style="--bs-breadcrumb-divider: '>';" aria-label="breadcrumb">
            <ol class="breadcrumb justify-content-center py-1">
               <li class="breadcrumb-item"><a href="{{ url('/') }}">Home</a></li>
               <li class="breadcrumb-item active" aria-current="page">Our Blog</li>
            </ol>
      </nav>
   </div>
</div>
<div class="container  mt-7 mb-7 ">

	<div class="d-xl-flex align-items-center">
		<!-- <h1 class="certzip-heading-color">Our Blog</h1> -->
		<div class="ms-xl-auto d-xl-flex flex-wrap"></div>
			
			<div class="mb-4 mb-xl-0 ms-xl-6">
				<div class="mb-4 mb-xl-0 ms-xl-6">

				<!-- Search -->
				<form class="" action="" method="get">
					<div class="input-group input-group-filter">
						<input type="hidden" name="category" value="{{ request()->get('category') }}">
						<input class="form-control form-control-sm placeholder-dark border-end-0" name="search" value="{{ request()->get('search') }}" type="search" placeholder="Search Our Blog" aria-label="Search">
						<div class="input-group-append">
							<button class="btn btn-sm btn-outline-white border-start-0 text-dark bg-transparent" type="submit">
							<!-- Icon -->
							<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M8.80758 0C3.95121 0 0 3.95121 0 8.80758C0 13.6642 3.95121 17.6152 8.80758 17.6152C13.6642 17.6152 17.6152 13.6642 17.6152 8.80758C17.6152 3.95121 13.6642 0 8.80758 0ZM8.80758 15.9892C4.8477 15.9892 1.62602 12.7675 1.62602 8.80762C1.62602 4.84773 4.8477 1.62602 8.80758 1.62602C12.7675 1.62602 15.9891 4.8477 15.9891 8.80758C15.9891 12.7675 12.7675 15.9892 8.80758 15.9892Z" fill="currentColor"/>
								<path d="M19.762 18.6121L15.1007 13.9509C14.7831 13.6332 14.2687 13.6332 13.9511 13.9509C13.6335 14.2682 13.6335 14.7831 13.9511 15.1005L18.6124 19.7617C18.7712 19.9205 18.9791 19.9999 19.1872 19.9999C19.395 19.9999 19.6032 19.9205 19.762 19.7617C20.0796 19.4444 20.0796 18.9295 19.762 18.6121Z" fill="currentColor"/>
							</svg>
							</button>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>
<div class="container pb-4 pb-xl-7">
	<div class="row row-cols-md-2 row-cols-lg-3 mb-8">


		<div class="col-xl-3 col-md-3 mb-5 mb-xl-0 p-md-0 is-affixed" id="category-sidebar">

			<div class="vertical-scroll sidebar__inner border rounded mb-6 bg-white" id="courseSidebar" style="position: relative; transform: translate3d(0px, 0px, 0px);">
			
				<div id="coursefilter1">
					<h4 class="mb-0">
					<button class="p-6 text-dark fw-medium d-flex align-items-center collapse-accordion-toggle line-height-one" type="button" data-bs-toggle="collapse" data-bs-target="#coursefiltercollapse1" aria-expanded="true" aria-controls="coursefiltercollapse1">
					Category
					<span class="ms-auto text-dark d-flex">
					
					<svg width="15" height="2" viewBox="0 0 15 2" fill="none" xmlns="http://www.w3.org/2000/svg">
					<rect width="15" height="2" fill="currentColor"></rect>
					</svg>
					<svg width="15" height="16" viewBox="0 0 15 16" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path d="M0 7H15V9H0V7Z" fill="currentColor"></path>
					<path d="M6 16L6 8.74228e-08L8 0L8 16H6Z" fill="currentColor"></path>
					</svg>
					</span>
					</button>
					</h4>
				</div>
				<div id="coursefiltercollapse1" class="collapse show mt-n2 px-6 pb-6 text-black" aria-labelledby="coursefilter1" data-parent="#courseSidebar">
					<ul class="list-unstyled list-group list-checkbox">
						@foreach ($cats as $key => $cat)
							<li class="custom-control custom-checkbox">
								<input type="radio" class="custom-control-input search-itemby-course side-filter" id="categorycustomcheckone{{ $key }}" name="courseradio" value="{{ $cat->slug }}" @if(request()->get('category')==$cat->category) checked @endif>
								<label class="custom-control-label font-size-base" for="categorycustomcheckone{{ $key }}">{{ $cat->category }}</label>
							</li>
						@endforeach
						
					</ul>
				</div>
			</div>
		</div>
		<div class="col-xl-9 col-md-9">
		<div class="row">
		@foreach($blogs as $blog)
			@php
				$blogtitle = $blog->title;
				$blogname = str_replace(" ","-",$blogtitle);
				$blogdate = date('d-m-Y',strtotime($blog->posted_date));
			@endphp
			<div class="col-md-4 mb-6">
				<!-- Card -->
				<div class="card border shadow p-2 lift sk-fade">
					<!-- Image -->
					<div class="card-zoom position-relative">
						<a href="{{ url('blog/' . $blog->slug) }}" class="card-img d-block sk-thumbnail img-ratio-3 blog-img-newone"><img class="rounded shadow-light-lg img-fluid" src="{{url('uploads/blogImages').'/'.$blog->image}}" alt="..."></a>
						<a href="{{ url('blog/' . $blog->slug) }}" class="badge sk-fade-bottom badge-lg badge-purple badge-pill badge-float bottom-0 left-0 mb-4 ms-4 px-5 me-4">
							<span class="text-white fw-normal font-size-sm">{{$blog->category}}</span>
						</a>
					</div>
					<!-- Footer -->
					<div class="card-footer px-2 pb-0 pt-4">
						<ul class="nav mx-n3 mb-3">
							<!-- <li class="nav-item px-3">
								<a href="#" class="d-flex align-items-center text-gray-800">
									<div class="me-3 d-flex">
										
										<svg width="15" height="15" viewBox="0 0 15 15" xmlns="http://www.w3.org/2000/svg">
											<path d="M13.8102 9.52183C13.313 9.08501 12.7102 8.70758 12.0181 8.40008C11.7223 8.2687 11.3761 8.40191 11.2447 8.69762C11.1134 8.99334 11.2466 9.33952 11.5423 9.47102C12.1258 9.73034 12.6287 10.0436 13.0367 10.4021C13.5396 10.8441 13.8281 11.484 13.8281 12.1582V13.2422C13.8281 13.5653 13.5653 13.8281 13.2422 13.8281H1.75781C1.43475 13.8281 1.17188 13.5653 1.17188 13.2422V12.1582C1.17188 11.484 1.46038 10.8441 1.96335 10.4021C2.55535 9.88186 4.2802 8.67188 7.5 8.67188C9.89079 8.67188 11.8359 6.72672 11.8359 4.33594C11.8359 1.94515 9.89079 0 7.5 0C5.10921 0 3.16406 1.94515 3.16406 4.33594C3.16406 5.7336 3.82896 6.97872 4.85893 7.77214C2.97432 8.18642 1.80199 8.98384 1.18984 9.52183C0.433731 10.1862 0 11.147 0 12.1582V13.2422C0 14.2115 0.788498 15 1.75781 15H13.2422C14.2115 15 15 14.2115 15 13.2422V12.1582C15 11.147 14.5663 10.1862 13.8102 9.52183ZM4.33594 4.33594C4.33594 2.59129 5.75535 1.17188 7.5 1.17188C9.24465 1.17188 10.6641 2.59129 10.6641 4.33594C10.6641 6.08059 9.24465 7.5 7.5 7.5C5.75535 7.5 4.33594 6.08059 4.33594 4.33594Z" fill="currentColor"/>
										</svg>
									</div>
									<div class="font-size-sm">Jack Wilson</div>
								</a>
							</li> -->
							<li class="nav-item px-3">
								<a href="#" class="d-flex align-items-center text-gray-800">
									<div class="me-2 d-flex">
										<!-- Icon -->
										<svg width="15" height="15" viewBox="0 0 15 15" xmlns="http://www.w3.org/2000/svg">
											<path d="M13.0664 1.17188H11.7188V0.46875C11.7188 0.209883 11.5089 0 11.25 0C10.9911 0 10.7812 0.209883 10.7812 0.46875V1.17188H4.21875V0.46875C4.21875 0.209883 4.0089 0 3.75 0C3.4911 0 3.28125 0.209883 3.28125 0.46875V1.17188H1.93359C0.867393 1.17188 0 2.03927 0 3.10547V13.0664C0 14.1326 0.867393 15 1.93359 15H13.0664C14.1326 15 15 14.1326 15 13.0664V3.10547C15 2.03927 14.1326 1.17188 13.0664 1.17188ZM1.93359 2.10938H3.28125V2.57812C3.28125 2.83699 3.4911 3.04688 3.75 3.04688C4.0089 3.04688 4.21875 2.83699 4.21875 2.57812V2.10938H10.7812V2.57812C10.7812 2.83699 10.9911 3.04688 11.25 3.04688C11.5089 3.04688 11.7188 2.83699 11.7188 2.57812V2.10938H13.0664C13.6157 2.10938 14.0625 2.55621 14.0625 3.10547V4.21875H0.9375V3.10547C0.9375 2.55621 1.38434 2.10938 1.93359 2.10938ZM13.0664 14.0625H1.93359C1.38434 14.0625 0.9375 13.6157 0.9375 13.0664V5.15625H14.0625V13.0664C14.0625 13.6157 13.6157 14.0625 13.0664 14.0625Z" fill="currentColor"/>
										</svg>
									</div>
									<div class="font-size-sm">{{$blogdate}}</div>
								</a>
							</li>
						</ul>
						<!-- Heading -->
						<a href="{{ url('blog/' . $blog->slug) }}" class="d-block"><h5 class="line-clamp-2 h-48 h-lg-52">{{$blog->title}}</h5></a>
					</div>
				</div>
			</div>	
		@endforeach
		{{ $blogs->withQueryString()->links() }}
		</div>
		</div>
	</div>
	
</div>
<script>
	$(document).on('change', '.side-filter', function(){
    var category = $(this).val();
    var url = "{{ route('blog.category', ':category') }}";
    url = url.replace(':category', category);
    window.location = url;  
});
	
</script>
@endsection
