@extends('layouts.app')
@section('content')
   <!-- Start Home Header -->
   <?php if(Route::currentRouteNamed('checkout')){?>
      @include('layouts.partial.menu')
   <?php }else{?>
      @include('layouts.partial.menuHome')
   <?php }?>
    <!-- End Home Header -->
    <!-- HERO ================================================== -->
      <section class="py-5 py-md-11 bg-light">
         <div class="container">
            <div class="row">
               <div class="col-lg-8 mb-6 mb-lg-0 position-relative">
                  <div id="primary" class="content-area">
                     <main id="main" class="site-main ">
                        <div class="page type-page status-publish hentry">
                           <!-- .entry-header -->
                           <div class="entry-content">
                              <div class="woocommerce">
                                 <form class="woocommerce-cart-form table-responsive" action="#" method="post">
                                    <table class="shop_table shop_table_responsive cart woocommerce-cart-form__contents">
                                       <thead>
                                          <tr>
                                             <th class="product-name">Courses</th>
                                             <th class="product-subtotal">Total</th>
                                             <th class="product-remove">&nbsp;</th>
                                          </tr>
                                       </thead>
                                       <tbody>
                                        <?php 
                                            $subtotal=0;
                                            $offprice=0;
                                            if(Auth::check()){
                                            $user_id = Auth::user()->id;
                                            foreach (cartDetail($user_id) as $data) { 
                                          //   $subtotal = $subtotal+$data->price;
                                            $offprice = $data->price_diff;
                                        ?>
                                          <tr class="woocommerce-cart-form__cart-item cart_item">
                                             <td class="product-name" data-title="Product">
                                                <div class="d-flex align-items-center">
                                                   <a href="#">
                                                   <img src="{{url('/uploads/course').'/'.$data->image}}" class="attachment-shop_thumbnail size-shop_thumbnail wp-post-image" alt="">
                                                   </a>
                                                   <div class="ms-6">
                                                      <a href="#"><?php echo $data->name; ?></a>
                                                   </div>
                                                </div>
                                             </td>
                                             <td class="product-subtotal" data-title="Total" style="padding: 1.9rem 5px">
                                                @php $date = \Carbon\Carbon::now(); @endphp
                                                @if(strtotime(\Carbon\Carbon::createFromFormat('Y-m-d H:i:s', $date)->format('Y-m-d')) > strtotime(\Carbon\Carbon::createFromFormat('Y-m-d', $data->price_deadline)->format('Y-m-d')))
                                                   <span class="woocommerce-Price-amount amount"><span class="woocommerce-Price-currencySymbol">{{ Config::get('app.currency_icon') }}</span><?php echo $data->cost; ?></span>
                                                   @php $subtotal = $subtotal+$data->cost; @endphp
                                                @else
                                                   @php $subtotal = $subtotal+$data->price; @endphp
                                                   <span class="woocommerce-Price-amount amount"><span class="woocommerce-Price-currencySymbol">{{ Config::get('app.currency_icon') }}</span><?php echo $data->price; ?></span>
                                                   <div class="d-flex align-items-center text-alizarin">
                                                      <!-- Icon -->
                                                      {{-- <svg width="10" height="10" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                                         <path d="M9.99974 3.0083C5.79444 3.0083 2.37305 6.42973 2.37305 10.635C2.37305 14.8405 5.79448 18.2619 9.99974 18.2619C14.2053 18.2619 17.6264 14.8405 17.6264 10.635C17.6264 6.42973 14.205 3.0083 9.99974 3.0083ZM9.99974 16.8797C6.55666 16.8797 3.7555 14.0783 3.7555 10.6353C3.7555 7.19219 6.55662 4.39103 9.99974 4.39103C13.4428 4.39103 16.244 7.19219 16.244 10.6353C16.244 14.0785 13.4428 16.8797 9.99974 16.8797Z" fill="currentColor"></path>
                                                         <path d="M12.1193 10.4048H10.2761V7.73202C10.2761 7.35022 9.9666 7.04077 9.5848 7.04077C9.20301 7.04077 8.89355 7.35022 8.89355 7.73202V11.0961C8.89355 11.4779 9.20301 11.7873 9.5848 11.7873H12.1194C12.5012 11.7873 12.8106 11.4779 12.8106 11.0961C12.8106 10.7143 12.5011 10.4048 12.1193 10.4048Z" fill="currentColor"></path>
                                                         <path d="M6.08489 15.5823C5.80102 15.3267 5.36391 15.35 5.10864 15.6336L3.0349 17.9378C2.77935 18.2214 2.80263 18.6585 3.08627 18.9138C3.2183 19.033 3.38372 19.0915 3.54849 19.0915C3.73767 19.0915 3.92614 19.0143 4.06255 18.8625L6.13629 16.5583C6.3918 16.2746 6.36852 15.8375 6.08489 15.5823Z" fill="currentColor"></path>
                                                         <path d="M16.9661 17.9381L14.8924 15.634C14.6375 15.3501 14.2002 15.327 13.9163 15.5826C13.6325 15.8379 13.6097 16.275 13.865 16.5586L15.9387 18.8628C16.0749 19.0144 16.2633 19.0916 16.4525 19.0916C16.6171 19.0916 16.7825 19.033 16.9147 18.9141C17.1986 18.6588 17.2214 18.2217 16.9661 17.9381Z" fill="currentColor"></path>
                                                         <path d="M5.96733 1.91597C4.59382 0.571053 2.3798 0.573123 1.03211 1.92105C0.361569 2.59132 -0.00479631 3.47819 4.74212e-05 4.41826C0.00512553 5.34705 0.373327 6.21665 1.03715 6.86689C1.17172 6.99845 1.34614 7.06411 1.52078 7.06411C1.69774 7.06411 1.87469 6.99638 2.00949 6.86181L5.9726 2.8987C6.10303 2.76808 6.17584 2.59085 6.17491 2.40632C6.17401 2.22171 6.09932 2.04523 5.96733 1.91597ZM1.5966 5.31939C1.45813 5.04037 1.38414 4.73162 1.38254 4.41088C1.37953 3.84315 1.60211 3.30581 2.00949 2.89843C2.41594 2.49222 2.95328 2.28921 3.49359 2.28921C3.80949 2.28921 4.12655 2.35855 4.4187 2.49726L1.5966 5.31939Z" fill="currentColor"></path>
                                                         <path d="M18.9673 1.92072C17.6194 0.573026 15.4053 0.570721 14.0318 1.91564C13.9 2.04489 13.8252 2.22142 13.8242 2.40595C13.8233 2.59052 13.8963 2.76794 14.0268 2.89833L17.9899 6.86144C18.1247 6.99648 18.3016 7.06398 18.4786 7.06398C18.6532 7.06398 18.8279 6.99831 18.9622 6.86628C19.6263 6.21628 19.9945 5.34672 19.9993 4.41789C20.0042 3.47809 19.6376 2.59122 18.9673 1.92072ZM18.4028 5.3193L15.5807 2.4972C16.3729 2.12114 17.3459 2.25458 17.9899 2.89856C18.3973 3.30594 18.6199 3.84301 18.6169 4.41102C18.6152 4.73152 18.5413 5.04051 18.4028 5.3193Z" fill="currentColor"></path>
                                                      </svg> --}}
                                                      @php
                                                         $to = \Carbon\Carbon::createFromFormat('Y-m-d H:s:i', $date);
                                                         $from = \Carbon\Carbon::createFromFormat('Y-m-d', $data->price_deadline);
                                                         $diff_in_days = $to->diffInDays($from);
                                                         // echo $to.'//'.$data->price_deadline.'//'.$diff_in_days;
                                                      @endphp
                                                      @if($diff_in_days <=7)
                                                      <span style="font-size: 10px;">{{$diff_in_days}} days left at this price!</span>
                                                      @endif
                                                </div>
                                               
                                               @endif
                                             </td>
                                             <td class="product-remove">
                                                <a href="{{url('user/delete-cart-item').'/'.$data->id}}" class="remove" aria-label="Remove this item">
                                                <i class="far fa-trash-alt text-secondary font-size-sm"></i>
                                                </a>
                                             </td>
                                          </tr>
                                          <?php } }?>
                                       </tbody>
                                    </table>
                                 </form>
                              </div>
                           </div>
                           <!-- .entry-content -->
                        </div>
                     </main>
                  </div>
               </div>
               <div class="col-lg-4" id="sidebar1">
                  <!-- SIDEBAR FILTER
                     ================================================== -->
                  <div class="d-block rounded border p-2 shadow mb-6 bg-white price-box">
                     <a href="https://www.youtube.com/watch?v=9I-Y6VQ6tyI" class="d-none sk-thumbnail rounded mb-1" data-fancybox>
                        <div class="h-60p w-60p rounded-circle bg-white size-20-all d-inline-flex align-items-center justify-content-center position-absolute center z-index-1">
                           <!-- Icon -->
                           <svg width="14" height="16" viewBox="0 0 14 16" xmlns="http://www.w3.org/2000/svg">
                              <path d="M12.8704 6.15374L3.42038 0.328572C2.73669 -0.0923355 1.9101 -0.109836 1.20919 0.281759C0.508282 0.673291 0.0898438 1.38645 0.0898438 2.18929V13.7866C0.0898438 15.0005 1.06797 15.9934 2.27016 16C2.27344 16 2.27672 16 2.27994 16C2.65563 16 3.04713 15.8822 3.41279 15.6591C3.70694 15.4796 3.79991 15.0957 3.62044 14.8016C3.44098 14.5074 3.05697 14.4144 2.76291 14.5939C2.59188 14.6982 2.42485 14.7522 2.27688 14.7522C1.82328 14.7497 1.33763 14.3611 1.33763 13.7866V2.18933C1.33763 1.84492 1.51713 1.53907 1.81775 1.3711C2.11841 1.20314 2.47294 1.21064 2.76585 1.39098L12.2159 7.21615C12.4999 7.39102 12.6625 7.68262 12.6618 8.01618C12.6611 8.34971 12.4974 8.64065 12.2118 8.81493L5.37935 12.9983C5.08548 13.1783 4.9931 13.5623 5.17304 13.8562C5.35295 14.1501 5.73704 14.2424 6.03092 14.0625L12.8625 9.87962C13.5166 9.48059 13.9081 8.78496 13.9096 8.01868C13.9112 7.25249 13.5226 6.55524 12.8704 6.15374Z" fill="currentColor"/>
                           </svg>
                        </div>
                        <img class="rounded shadow-light-lg" src="{{asset('img/products/product-2.jpg')}}" alt="...">
                     </a>
                     <div class="pt-5 pb-4 px-5 px-lg-3 px-xl-5">
                        <div class="d-flex align-items-center mb-2">
                           <ins class="h2 mb-0">{{ Config::get('app.currency_icon') }}<?php echo $subtotal; ?></ins>
                           <del class="ms-3">{{ Config::get('app.currency_icon') }}339.99</del>
                           {{-- <div class="badge badge-lg badge-purple text-white ms-auto fw-normal">{{$offprice}}% Off</div> --}}
                        </div>
                        <!-- <div class="coupon-code-sec">
                           <b>Enter coupon code </b>
                           <div class="input-group mb-3">
                              <input type="text" class="form-control coupon-code1" placeholder="COUPON CODE" aria-label="Recipient's username" aria-describedby="basic-addon2">
                              <div class="input-group-append">
                                 <button class="btn btn-outline-secondary cbtn1" type="button"><span class="capply1">Apply</span></button>
                              </div>
                           </div>
                        </div> -->
                        @if(Auth::check())
                           {{-- <a href="{{route('paypalPayment')}}">
                              <button class="btn btn-primary btn-block mb-3" type="button" name="button">PAY NOW</button>
                           </a> --}}
                           <div id="paypal-course-button"></div>
                        @else
                           <button class="btn btn-primary btn-block mb-3" type="button" name="button">PAY NOW</button>
                        @endif
                     </div>
                  </div>
                  <div class="d-none">
                     <div class="border rounded px-6 px-lg-5 px-xl-6 pt-5 shadow">
                        <h3 class="mb-5">Latest Courses</h3>
                        <ul class="list-unstyled mb-0">
                           <li class="media mb-6 d-flex">
                              <a href="#" class="w-100p d-block me-5">
                              <img src="assets/img/photos/photo-1.jpg" alt="..." class="avatar-img rounded-lg h-90p w-100p">
                              </a>
                              <div class="media-body flex-grow-1">
                                 <a href="#" class="d-block">
                                    <h6 class="line-clamp-2 mb-3">Web Developtment and Design</h6>
                                 </a>
                                 <del class="font-size-sm me-2">$959</del>
                                 <ins class="h6 mb-0 ">$415.99</ins>
                              </div>
                           </li>
                           <li class="media mb-6 d-flex">
                              <a href="#" class="w-100p d-block me-5">
                              <img src="assets/img/photos/photo-2.jpg" alt="..." class="avatar-img rounded-lg h-90p w-100p">
                              </a>
                              <div class="media-body flex-grow-1">
                                 <a href="#" class="d-block">
                                    <h6 class="line-clamp-2 mb-3">The Complete Cyber Security Course : Hackers </h6>
                                 </a>
                                 <del class="font-size-sm me-2">$959</del>
                                 <ins class="h6 mb-0 ">$415.99</ins>
                              </div>
                           </li>
                           <li class="media mb-6 d-flex">
                              <a href="#" class="w-100p d-block me-5">
                              <img src="assets/img/photos/photo-14.jpg" alt="..." class="avatar-img rounded-lg h-90p w-100p">
                              </a>
                              <div class="media-body flex-grow-1">
                                 <a href="#" class="d-block">
                                    <h6 class="line-clamp-2 mb-3">Fashion Photography From Professional</h6>
                                 </a>
                                 <del class="font-size-sm me-2">$959</del>
                                 <ins class="h6 mb-0 ">$415.99</ins>
                              </div>
                           </li>
                           <li class="media mb-6 d-flex">
                              <a href="#" class="w-100p d-block me-5">
                              <img src="assets/img/photos/photo-16.jpg" alt="..." class="avatar-img rounded-lg h-90p w-100p">
                              </a>
                              <div class="media-body flex-grow-1">
                                 <a href="#" class="d-block">
                                    <h6 class="line-clamp-2 mb-3">The Complete Financial Analyst Course 2020</h6>
                                 </a>
                                 <del class="font-size-sm me-2">$959</del>
                                 <ins class="h6 mb-0 ">$415.99</ins>
                              </div>
                           </li>
                        </ul>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </section>
   @if(Auth::check())
   <script src="https://www.paypal.com/sdk/js?client-id={{env('PAYPAL_CLIENT_ID')}}&locale=en_US&components=messages,buttons{{env('PAYPAL_ENVORINMENT')=='sandbox' ? '&buyer-country=US' : '&enable-funding=paylater'}}&disable-funding=card"></script>
         <script>
            paypal.Buttons({
               style: {
                  layout: 'vertical',
                  color:  'white',
                  shape:  'pill',
                  label:  ''
               },
               //od_create = false;
               createOrder: function() {
                  let formData = new FormData();
                  formData.append('_token', "{{csrf_token()}}");
                  
                     return fetch( 
                           "{{route('paypal-cart-order-create')}}",
                           {
                              method: 'POST',
                              // headers: {
                              //    'X-CSRFToken': "{{csrf_token()}}"
                              // },
                              body: formData
                           }
                        ).then(function(response) {
                           return response.json();
                        }).then(function(resJson) {
                           console.log('Order ID: '+ resJson.data.id);
                           return resJson.data.id;
                        });

                        //return od_create;            
               },
               // Wait for the payment to be authorized by the customer
               onApprove: function(data, actions) {
                     let formData = new FormData();
                     formData.append('_token', "{{csrf_token()}}");
                     return fetch(
                        "{{route('paypal-order-capture')}}",
                        {
                           method: 'POST',
                           body: formData
                        }
                     ).then(function(res) {
                        return res.json();
                     }).then(function(res) {
                        if(res.data.hasOwnProperty('status') && res.data.status=='COMPLETED')
                        {
                           window.setTimeout(()=>{
                              window.location.href = "{{url('/thank-you')}}";
                           },2000);
                        }
                        else
                        {
                           alert('Due to some error please try again.');
                        }
                     });
               }
               
            }).render('#paypal-course-button');
         </script>
   @endif
@endsection