<div class="owl-carousel owl-course_1">
    @php $allcourses = $course; @endphp
    @if(!empty($allcourses) && count($allcourses) > 0)
        @foreach($allcourses as $courses)
            @php
                $coursename = $courses->name;
                $coursestring = str_replace(' ', '-', $coursename);
            @endphp
            <div class="item">
                <!-- items -->
                <div class="courses_tabs_design_box">
                    <div class="popular_Courses">
                        <img src="{{url('/uploads/course').'/'.$courses->image}}" alt="">
                    </div>
                    <div class="card p-2">
                        <div class="fs_18 fw_600 course_title_heading">
                            <a href="{{ route('courseDetail', $courses->slug) }}">{{$courses->name}}</a>
                        </div>
                        <div class="fs_14">Reviews</div>
                        @if($courses->rating!=null)   @endif
                            <div class="rating full-star-row">
                                <div class="empty-star">
                                <span class="far fa-star"></span>
                                <span class="far fa-star"></span>
                                <span class="far fa-star"></span>
                                <span class="far fa-star"></span>
                                <span class="far fa-star"></span>
                                </div>
                                <div class="overlay-star" style="width:<?php echo 100-(($courses->rating*10)*2); ?>%;"  ></div>
                                <div class="fill-star">
                                <span class="fas fa-star"></span>
                                <span class="fas fa-star"></span>
                                <span class="fas fa-star"></span>
                                <span class="fas fa-star"></span>
                                <span class="fas fa-star"></span>
                                </div>
                            </div>
                            <!-- <div class="font-size-xs data-rating-1 ms-lg-3">
                                    <span>{{number_format((float)$courses->rating, 1, '.', '')}} ({{ $courses->r_count }})</span>
                            </div> -->
                        <div class="d-flex align-items-center justify-content-between">
                            <div>{{ Config::get('app.currency_icon') }}{{ $courses->price }}</div>
                            <div class="offers">{{ Config::get('app.currency_icon') }}{{ $courses->price_diff }} off</div>
                        </div>
                    </div>
                </div>
                <!-- items -->
            </div>
        @endforeach
    @else
        <div class="not-found-message">No record found.</div>
    @endif
</div>

<script type="text/javascript">
    $('.owl-course_1').owlCarousel({
        loop: true,
        margin: 10,
        nav: true,
        responsive: {
            0: {
                items: 1,
                nav: true,
                dots: false,
            },
            600: {
                items: 3,
                nav: true,
                dots: false,
            },
            1000: {
                items: 4,
                nav: true,
                dots: false,
            }
        }
    });
</script>
