@extends('layouts.app')
@section('content')
@include('layouts.partial.menu')
     <div class="container-fluid text-center pt-6 pb-4 shadow border rounded blue-gradient">
        <div class="mb-4">
            <h1 class="mb-1 text-white">Voucher Payment</h1>
            <nav class="" style="--bs-breadcrumb-divider: '>';" aria-label="breadcrumb">
                 <ol class="breadcrumb justify-content-center py-1">
                    <li class="breadcrumb-item"><a href="{{ url('/') }}">Home</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Voucher Payment</li>
                 </ol>
           </nav>
        </div>
     </div>
      <div class="container mt-7 mb-7">
   <!-- VIDEO ================================================== -->
      <style>
         .select2-container .select2-selection--single .select2-selection__rendered { padding: 1rem 1.25rem; border: 1px solid #e7e7ec; }
         .select2-container .select2-selection--single { height: unset; border: 1px solid #e7e7ec; }
         .select2-container--default .select2-selection--single .select2-selection__arrow{ height: 60px;top: 2px; }
         .text-danger {--bs-text-opacity: 1;color: rgb(220, 0, 0); }
      </style>
      <div class="content-block">
         <!-- About Us ==== -->
         <div class="section-area section-sp1">
             <div class="container">
 
                 <div class="row">
                     <div class="col-md-6 offset-md-3 p-5 border rounded bg_primary_2 shadow-sm" style="background: #fff;">
                         {{-- <form class="needs-validation" method="POST" action="{{ route('vouchar-payment-submit') }}" id="voucer-payment-form"> --}}
                        <form class="needs-validation" method="POST" action="{{ route('voucher-form-validate') }}" id="voucer-payment-form">
                           @csrf
                            <!--  <br>
                             <h1 class="mb-3 certzip-heading-color">Voucher Payment</h1> -->
 
                              <div class="row">
                                 <div class="col-md-12 mb-3">
                                     <label for="firstName"> Name* </label>
                                     <input type="text" class="form-control" name="name" id="cardholder-name" value="{{ (auth()->check())?auth()->user()->name:'' }}" required {{ (auth()->check())?'readonly':'' }}>
                                     @if ($errors->has('name')) <span class="text-danger">{{ $errors->first('name') }}</span> @endif
                                     <p style="margin-bottom: 2px;" class="text-danger error_container" id="error-name"></p>
                                 </div>
                                 <div class="col-md-12 mb-3">
                                     <label for="zip">Email*</label>
                                     <input type="text" class="form-control" required name="email" id="cardholder-email" value="{{ (auth()->check())?auth()->user()->email:'' }}" {{ (auth()->check())?'readonly':'' }}>
                                     @if ($errors->has('email')) <span class="text-danger">{{ $errors->first('email') }}</span> @endif
                                     <p style="margin-bottom: 2px;" class="text-danger error_container" id="error-email"></p>
                                 </div>
 
                                 <div class="col-md-12 mb-3">
                                     <label for="lastName">Mobile*</label>
                                     <div class="form-group">
                                         <input class="form-control" type="tel" name="mobile" id="mobile-number" placeholder="e.g. +1 702 123 4567" style="text-indent: 35px;" value="{{ (auth()->check())?auth()->user()->mobile_no:'' }}"  {{ (auth()->check())?'readonly':'' }}>
                                         @if ($errors->has('mobile')) <span class="text-danger">{{ $errors->first('mobile') }}</span> @endif
                                         <p style="margin-bottom: 2px;" class="text-danger error_container" id="error-mobile"></p>
                                     </div>
                                 </div>
                                 <div class="col-md-12 mb-3">
                                     <label for="zip">Voucher Code*</label>
                                     <input type="text" class="form-control error-control"  name="code" id="vouchar_code">
                                     @if ($errors->has('code')) <span class="text-danger">{{ $errors->first('code') }}</span> @endif
                                     <p style="margin-bottom: 2px;" class="text-danger error_container" id="error-code"></p>
                                 </div>
                              </div>
 
                              <div class="row">
                                 <div class="col-md-12 mb-3">
                                     <label for="zip">Course*</label>
                                     
                                     <select class="form-control select2-field error-control" name="course[]" id="course" multiple="multiple">
                                        <option value=""> Select Course</option>
                                        <option value="0"> Other</option>
                                        @foreach ($courses as $course)
                                          <option value="{{ $course->id }}"> {{ $course->name }}</option>
                                        @endforeach
                                     </select>
                                     @if ($errors->has('course')) <span class="text-danger">{{ $errors->first('course') }}</span> @endif
                                     <p style="margin-bottom: 2px;" class="text-danger error_container" id="error-course"></p>
                                 </div>
                              </div>
 
                              <div class="row">
                                 <div class="col-md-12 mb-0">
                                    <label for="zip">Voucher payable for*</label>
                                 </div>
                                 <div class="col-md-12 mb-3 d-lg-flex">
                                    <div class="custom-control custom-radio">
                                         <input id="voucherPaymentPartial" name="voucherPaymentFor" type="radio" value="Partial" class="error-control" >
                                         <label for="voucherPaymentPartial">Partial</label>
                                    </div>
                                    <div class="custom-control custom-radio">
                                         <input id="paymentMethodRemaing" name="voucherPaymentFor" type="radio" value="Remaing" class="error-control" >
                                         <label for="paymentMethodRemaing">Remaining</label>
                                    </div>
                                    <div class="custom-control custom-radio">
                                         <input id="paymentMethodFull" name="voucherPaymentFor" type="radio" value="Complete" class="error-control"  checked>
                                         <label for="paymentMethodFull">Complete</label>
                                    </div>
                                    @if ($errors->has('voucherPaymentFor')) <span class="text-danger">{{ $errors->first('voucherPaymentFor') }}</span> @endif
                                    <p style="margin-bottom: 2px;" class="text-danger error_container" id="error-voucherPaymentFor"></p>
                                 </div>
                              </div>
 
                              <div class="row">
                                 <div class="col-md-12 mb-5 pay-one">
                                    <label for="zip" id="lblPaymentAmount">Payable Amount *</label>
                                    <div class="input-group mb-3">
                                       <div class="input-group-prepend">
                                          <span class="input-group-text">
                                             {{ Config::get('app.currency_icon') }}
                                          </span>
                                       </div>
                                       <input type="text" class="form-control error-control"  name="amount" id="vouchar_amount" pattern="[0-9]*">
                                    </div>
                                    @if ($errors->has('amount')) <span class="text-danger">{{ $errors->first('amount') }}</span> @endif
                                    <p style="margin-bottom: 2px;" class="text-danger error_container" id="error-amount"></p>
                                 </div>
                              </div>
 
 
                              <div class="row">
                                 <div class="col-md-12 mt-2 voucher-btn">
                                    <div class="row">
                                       <div class="col-sm-12 text-center mb-3">
                                          {{-- <input name="VoucharPayment" value="Pay Safe" class="btn btn-primary btn-lg submit" style="margin:0 auto;font-size:18px;font-weight:700;" type="submit"> --}}
                                          <button type="submit" class="btn btn-primary btn-lg submit" style="margin:0 auto;font-size:18px;font-weight:700;">Pay Safe</button>
                                       </div>
                                    </div>
                                 </div>
                                 <div class="col-12 paypal-voucher d-none">
                                    <div id="paypal-voucher-button"></div>
                                 </div>
                              </div>
                        </form>
                     </div>
 
 
 
                 </div>
 
 
             </div>
         </div>
     </div>
     <!-- END -->
</div>
<!-- ICON BLOCKS ================================================== -->
<script src="https://www.paypal.com/sdk/js?client-id={{env('PAYPAL_CLIENT_ID')}}&locale=en_US&components=messages,buttons{{env('PAYPAL_ENVORINMENT')=='sandbox' ? '&buyer-country=US' : '&enable-funding=paylater'}}&disable-funding=card"></script>
<script>
    //$("#mobile-number").intlTelInput();
      $('.select2-field').select2();

      //{containerCssClass: "form-control",multiple: true,}

      $('#vouchar_code').keyup(function() {
         $(this).val($(this).val().replace(/[^\w\s]+/g, ''));
      });   
   $(document).ready(function(){
      

      // $('#vouchar_amount').keyup(function() {
      //    $(this).val($(this).val().replace(/[0-9]/g, ''));
      // });
      $(document).on('submit', 'form#voucer-payment-form', function (event) {
        event.preventDefault();
         //clearing the error msg
         $('p.error_container').html("");

            var form = $(this);
            var data = new FormData($(this)[0]);
            var url = form.attr("action");
            var loadingText = '<i class="fa fa-circle-o-notch fa-spin"></i> loading...';
            $('.submit').attr('disabled',true);
            $('.error-control').attr('readonly',true);
            $('.error-control').addClass('disabled-link');
            if ($('.submit').html() !== loadingText) {
                  $('.submit').html(loadingText);
            }
            $.ajax({
                type: form.attr('method'),
                url: url,
                data: data,
                cache: false,
                contentType: false,
                processData: false,      
                success: function (response) {
                    window.setTimeout(function(){
                        $('.submit').attr('disabled',false);
                        $('.error-control').attr('readonly',false);
                        $('.error-control').removeClass('disabled-link');
                        $('.submit').html('Pay Safe');
                      },2000);
                    // console.log(response);
                    if(response.success==true  ) {  
                        window.setTimeout(function(){        
                           $('.error-control').attr('readonly',false);
                           $('.error-control').removeClass('disabled-link');
                           $('.voucher-btn').addClass('d-none');
                           $('.paypal-voucher').removeClass('d-none');
                        },2000);
                    }
                    //show the form validates error
                    if(response.success==false ) {  
                        var i=0;                            
                        for (control in response.errors) {   
                            $('#error-' + control).html(response.errors[control]);
                            if(i==0)
                            {
                                $('select[name='+control+']').focus();
                                $('input[name='+control+']').focus(); 
                                $('textarea[name='+control+']').focus();
                            }
                            i++;  
                        }
                    }
                },
                error: function (xhr, textStatus, errorThrown) {
                    // alert("Error: " + errorThrown);
                }
            });
            return false;
      });
   });
  

   paypal.Buttons({
               style: {
                  layout: 'vertical',
                  color:  'white',
                  shape:  'pill',
                  label:  ''
               },
               //od_create = false;
               createOrder: function() {
                  let formData = new FormData();
                  // var val_select= $('#course').val();
                  var selectedValues = $("#course").val();
                  for (var i = 0; i < selectedValues.length; i++) {
                    formData.append("course[]", selectedValues[i]);
                  }


                  // var valitem=$('#course').find(':selected').val();
                  formData.append('_token', "{{csrf_token()}}");
                  formData.append('name', $('#cardholder-name').val());
                  formData.append('email', $('#cardholder-email').val());
                  formData.append('mobile', $('#mobile-number').val());
                  formData.append('code', $('#vouchar_code').val());
                  // formData.append('course', $('#course').val());
                  formData.append('voucherPaymentFor', $('input[name="voucherPaymentFor"]:checked').val());
                  formData.append('amount', $('#vouchar_amount').val());
                     return fetch( 
                           "{{route('paypal-voucher-order-create')}}",
                           {
                              method: 'POST',
                              // headers: {
                              //    'X-CSRFToken': "{{csrf_token()}}"
                              // },
                              body: formData
                           }
                        ).then(function(response) {
                           return response.json();
                        }).then(function(resJson) {
                           console.log('Order ID: '+ resJson.data.id);
                           return resJson.data.id;
                        });

                        //return od_create;            
               },
               // Wait for the payment to be authorized by the customer
               onApprove: function(data, actions) {
                     let formData = new FormData();
                     formData.append('_token', "{{csrf_token()}}");
                     return fetch(
                        "{{route('paypal-voucher-order-capture')}}",
                        {
                           method: 'POST',
                           body: formData
                        }
                     ).then(function(res) {
                        return res.json();
                     }).then(function(res) {
                        if(res.data.hasOwnProperty('status') && res.data.status=='COMPLETED')
                        {
                           window.setTimeout(()=>{
                              window.location.href = "{{url('/thank-you')}}";
                           },2000);
                        }
                        else
                        {
                           alert('Due to some error please try again.');
                        }
                     });
               }
   }).render('#paypal-voucher-button');
</script>
@endsection