<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Subscription; // Adjust if you have a different model
use Carbon\Carbon;
use Stripe\Stripe;
use Stripe\Subscription as StripeSubscription;

class CheckSubscriptions extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'subscriptions:check';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Check active subscriptions that ended yesterday and verify with Stripe';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        // \Log::info('Check CheckSubscriptions: ');
        // Set Stripe API key
        Stripe::setApiKey(config('services.stripe.secret'));

        $yesterday = Carbon::yesterday()->toDateString();
        // $today = Carbon::today()->startOfDay();

        // dd($yesterday,$today);

        $subscriptions = Subscription::where('status', 'active')
            ->where('end_at',$yesterday)
            ->get();
        // dd($subscriptions);
        // \Log::info('Stripe Success SESSION: ' . $subscriptions);
        foreach ($subscriptions as $subscription) {
            try {

                if($subscription->stripe_subscription_id=='Free Trial')
                {
                    // $stripeSubscription = StripeSubscription::retrieve('sub_1RUjfFAcDfuT5qeAO2VXpKTW');
                    // \Log::info('Check CheckSubscriptions: '.$stripeSubscription);
                    // die;
                    $subscription->update([
                        'status' => 'canceled',
                    ]);
                }
                else{
                    // Assuming you store Stripe subscription ID
                    // $stripeSubscription = StripeSubscription::retrieve($subscription->stripe_subscription_id);
                    // \Log::info('Check CheckSubscriptions: ');
                    // if ($stripeSubscription->status !== 'active') {
                        // Update your local subscription status
                        $update['status'] = $stripeSubscription->status;
                        if(isset($stripeSubscription->current_period_end) && $stripeSubscription->current_period_end!='')
                        {
                            $update['end_at'] = date("Y-m-d",$stripeSubscription->current_period_end);
                        }
                        $subscription->update([$update]);

                        $this->info("Subscription {$subscription->id} updated to {$stripeSubscription->status}");
                    // } else {
                    //     $this->info("Subscription {$subscription->id} is still active.");
                    // }
                }
            } catch (\Exception $e) {
                $this->error("Error checking subscription {$subscription->id}: " . $e->getMessage());
            }
        }

        return 0;
    }
}
