<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Models\Faq;
use App\Models\FaqCategory;
use Carbon\Carbon;
use DB;

class FaqController extends Controller
{
    public function index(Request $request)
    {
        $query = Faq::with('category')->latest();

        if ($request->filled('search')) {
            $search = $request->search;
            $query->where('question', 'like', "%$search%");
        }

        $faqs = $query->paginate(10);

        if ($request->ajax()) {
            return view('admin.faq.ajax', compact('faqs'))->render();
        }

        return view('admin.faq.list', compact('faqs'));
    }

    public function create()
    {
        // $categories = FaqCategory::all();
        $categories = FaqCategory::where('status','1')->get();
       
        return view('admin.faq.create', compact('categories'));
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'question'  => 'required|string|unique:faqs,question|max:255',
            'answer'    => 'required|string|unique:faqs,answer',
            'category_id' => 'required|exists:faq_categories,id',
            'status'    => 'required|boolean',
        ]);

        Faq::create($validated);

        return response()->json(['message' => 'FAQ Created Successfully']);
    }

    public function edit($id)
    {
        // $categories = FaqCategory::all();
         $categories = FaqCategory::where('status','1')->get();

         $faq = Faq::findOrFail(base64_decode($id)); 
        return view('admin.faq.edit', compact('faq','categories'));
    }

    public function update(Request $request)
    {
        $id = base64_decode($request->id);
        // $validated = $request->validate([
        //     'question'  => 'required|string|max:255',
        //     'answer'    => 'required|string',
        //     'category_id' => 'required|exists:faq_categories,id',
        //     'status'    => 'required|boolean',
        // ]);

        // $faq->update($validated);

        // return response()->json(['message' => 'FAQ Updated Successfully']);

        $rules = [
            'question'    => 'required|string|unique:faqs,question'.$id.'|max:255',
            'answer'      => 'required|string|unique:faqs,answer'.$id,
            'category_id' => 'required|exists:faq_categories,id',
            'status'      => 'required|boolean',
            
        ];

        $messages = [
            'question.required'     => 'Question is required.',
            'question.unique'       => 'This Question already exists.',
            'answer.required'       => 'Answer is required.',
            'answer.unique'         => 'This Answer already exists.',
            'category_id.required'  => 'Category_id is required.',
            'status.required'       => 'Status is required.',
 
        ];

       $validation = Validator::make($request->all(), $rules,$messages);
        if ($validation->fails()) {

            return response()->json([
                'success' => false,
                'errors' => $validation->errors()
            ]);
        }

        // DB::beginTransaction();

          try {
            $faq = Faq::findOrFail($id);

            $faq->question  = $request->question;
            $faq->answer  = $request->answer;
            $faq->category_id  = $request->category_id;
            $faq->status  = $request->status;
           
            $faq->save();

            // DB::commit();

           return response()->json([
                'success' => true,
                'message' => 'FAQ updated successfully.'
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'errors' => ['server' => [$e->getMessage()]]
            ]);
        }

    }

    public function destroy(Request $request)
    {
        try {
            $id = base64_decode($request->id);
            $student = Faq::findOrFail($id);
            $student->delete();
    
            return response()->json(['success' => true, 'message' => 'Faq deleted successfully']);
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => $e->getMessage()]);
        }
    }

    public function faqStatus(Request $request)
    {
        $stu_id = base64_decode($request->id);
        $type   = base64_decode($request->type);
        $user   = Faq::find($stu_id);
        $user->status = ($type == 'enable') ? 1 : 0;
        $user->save();
        return response()->json([
            'success'=>true,
            'type' => $type,
            'message'=>'Status change successfully.'
        ]);
    }
}
