<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\FaqCategory;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Hash;
use Carbon\Carbon;
use DB;
use Auth;

class FaqcategoryController extends Controller
{

    // public function index()
    // {
    //     $faqcategory = FaqCategory::orderBy('created_at', 'desc')->get();
    //     return view('admin.faq-category.list', compact('faqcategory'));
       
    // }

      public function index(Request $request)
    {
        $query = FaqCategory::orderBy('created_at', 'desc');
        
        if ($request->filled('search')) {
            $search = $request->search;
            $query->where('name', 'like', '%' . $search . '%');
                    
        }
        $faqcategory  = $query->paginate(10);

        if ($request->ajax()) {
            return view('admin.faq-category.ajax', compact('faqcategory'))->render();
        }
        return view('admin.faq-category.list', compact('faqcategory'));
    }

    public function faq_create(Request $request){
        $createfaqcat = FaqCategory::select('id', 'name')->where('status', 1)->get();
         
       return view('admin.faq-category.create',compact('createfaqcat'));
    }

    public function faqcat_store(Request $request){
        $rules = [
            'name'       =>'required|unique:faq_categories,name|regex:/^[A-Za-z\s]+$/',
            'status'     =>'required'
        ];

        $messages = [
            'name.required'      => 'Name is required.',
            'name.unique'        =>'This name already exists.',
            'name.regex'        =>'Name field accept only letters.',
            'status.required'    =>'Status is required.',
           
        ];

        $validation = Validator::make($request->all(), $rules, $messages);
        if ($validation->fails()) {
            return response()->json([
                'success' => false,
                'errors' => $validation->errors()
            ], 200);
        }

        // DB::beginTransaction();
        try{

            $insert_arr = array(
            'name'      =>$request->name,
            'status'     =>$request->status,
            'created_at'   => Carbon::now(),
            );

            $insert = FaqCategory::insert($insert_arr);

            // DB::commit();
            return response()->json(['success' => true]);
        }
        catch (\Exception $e) {
            // DB::rollback();
            return response()->json(['success' => false, 'message' => 'Something went wrong: ' . $e->getMessage()], 500);
        }

    }

    public function faqcat_edit($id)
    {
        $faqcategory = FaqCategory::findOrFail(base64_decode($id)); 

        return view('admin.faq-category.edit', compact('faqcategory'));
    }

   

    public function faqcat_update(Request $request)
    {
        $id = base64_decode($request->id);

        $rules = [
           'name'       =>'required|unique:faq_categories,name,'.$id.'|regex:/^[A-Za-z\s]+$/',
            
        ];

        $messages = [
            'name.required'     =>'Name is required.',
            'name.unique'       =>'This name already exists.',
            'name.regex'        =>'Name field accept only letters.',
           
        ];

        $validation = Validator::make($request->all(), $rules, $messages);

        if ($validation->fails()) {
            if ($validation->fails()) {
                return response()->json([
                    'success' => false,
                    'errors' => $validation->errors()
                ], 200);
            }
        }

        // DB::beginTransaction();

        try {
            $faqcat = FaqCategory::findOrFail($id);

            $faqcat->name  = $request->name;
            $faqcat->status= $request->status;
          
            $faqcat->save();

            // DB::commit();

            return response()->json(['success' => true]);

        } catch (\Exception $e) {
            // DB::rollback();

            return response()->json(['success' => false, 'message' => 'Something went wrong: ' . $e->getMessage()], 500);
        }
    }

   
    public function faqcat_delete(Request $request)
    {
        try {
            $id = base64_decode($request->id);
            $student = FaqCategory::findOrFail($id);
            $student->delete();
    
            return response()->json(['success' => true, 'message' => 'Faqcategory deleted successfully']);
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => $e->getMessage()]);
        }
    }
    
       
        public function faqcatStatus(Request $request)
        {
            $stu_id=base64_decode($request->id);
            $type = base64_decode($request->type);
        
            if($type == 'disable')
            { 
                $user = FaqCategory::find($stu_id);
                $user->status = '0';
                $user->save();
                
                return response()->json([
                    'success'=>true,
                    'type' => $type,
                    'message'=>'Status change successfully.'
                ]);
            }
            elseif($type == 'enable')
            {   
                $user = FaqCategory::find($stu_id);
                $user->status = '1';
                $user->save();
            
                return response()->json([
                    'success'=>true,
                    'type' => $type,
                    'message'=>'Status change successfully.'
                ]);
            }
        }
  
   
   
}
