<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Feedback;
use App\Models\User;
use App\Models\FeedbackOption;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use DB;
use Auth;

class FeedbackController extends Controller
{

//     public function index(Request $request)
// {
//     $query = Feedback::with(['user']) 
//         ->whereNotNull('user_id')
//         ->whereNotNull('oid')
//         ->orderBy('id', 'desc');

//     if ($request->filled('search')) {
//         $search = $request->search;
//         $query->whereHas('user', function ($query) use ($search) {
//             $query->where('name', 'like', '%' . $search . '%');
            
//         });
//          $query->orWhereHas('option', function ($query) use ($search) {
//             $query->where('name', 'like', '%' . $search . '%');
//         });
    
//     }

//     // Fetch all feedbacks with pagination
//     $feedbacks = $query->paginate(5);

//     // Prepare all option names in a lookup array
//     $allOptionNames = FeedbackOption::pluck('name', 'id')->toArray();

//     if ($request->ajax()) {
//         return view('admin.feedback.ajax', compact('feedbacks', 'allOptionNames'))->render();
//     }

//     return view('admin.feedback.list', compact('feedbacks', 'allOptionNames'));
// }

public function index(Request $request)
{
    $query = Feedback::with(['user', 'option']) 
        ->whereNotNull('user_id')
        ->whereNotNull('oid')
        ->orderBy('id', 'desc');

    if ($request->filled('search')) {
        $search = $request->search;
        
        $query->where(function ($q) use ($search) {
           
            $q->whereHas('user', function ($subQuery) use ($search) {
                $subQuery->where('name', 'like', '%' . $search . '%');
            });
            
            $q->orWhereHas('option', function ($subQuery) use ($search) {
                $subQuery->where('name', 'like', '%' . $search . '%');
            });
        });
    }
    
    $feedbacks = $query->paginate(10);
    $allOptionNames = FeedbackOption::pluck('name', 'id')->toArray();
    if ($request->ajax()) {
        return view('admin.feedback.ajax', compact('feedbacks', 'allOptionNames'))->render();
    }
    return view('admin.feedback.list', compact('feedbacks', 'allOptionNames'));
}


    public function feedback_view(Request $request)
    {
        try {
            $id = base64_decode($request->id); 
            $feedback = Feedback::with('user')->findOrFail($id);
            // dd($feedback);
            $oids = json_decode($feedback->oid, true);
           
            $optionNames = FeedbackOption::whereIn('id', $oids)->pluck('name')->toArray();
    
            return view('admin.feedback.view', compact('feedback', 'optionNames'));
    
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Feedback not found.');
        }
    }

   

    
  
}
