<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\FeedbackOption;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Hash;
use Carbon\Carbon;
use DB;
use Auth;

class FeedbackOptionController extends Controller
{
    public function index(Request $request)
    {
        $query = FeedbackOption::orderBy('created_at', 'desc');
        if ($request->filled('search')) {
            $search = $request->search;                            
            $query->where('name', 'like', '%' . $search . '%');
        }
        // $feedbackoption = $query->paginate(5);
        $perPage = $request->get('per_page', 10);

        // If "all", show all records
        if ($perPage === 'all') {
            $feedbackoption = $query->get(); 
        } else {
            $feedbackoption = $query->paginate((int) $perPage);
        }

        if ($request->ajax()) {
            return view('admin.feedback-option.ajax', compact('feedbackoption'))->render();
        }
        return view('admin.feedback-option.index', compact('feedbackoption'));
       
    }

    public function feedbackoption_create(Request $request){
        $createfeedoption = FeedbackOption::select('id', 'name')->where('status', 1)->get();
       return view('admin.feedback-option.create',compact('createfeedoption'));
    }

    public function feedbackoption_store(Request $request){

        $rules = [
            'name'       =>'required|unique:feedback_options,name',
            'status'     =>'required'
            
        ];

        $messages = [
            'name.required'      =>'Name is required.',
            'name.unique'        =>'This name already exists.',
            'status.required'    =>'Status is required.',
           
        ];

        $validation = Validator::make($request->all(), $rules, $messages);
        if ($validation->fails()) {
            return response()->json([
                'success' => false,
                'errors' => $validation->errors()
            ], 200);
        }

        // DB::beginTransaction();
        try{

            $insert_arr = array(
            'name'      =>$request->name,
            'status'     =>$request->status,
            'created_at'   => Carbon::now(),
            );

            $insert = FeedbackOption::insert($insert_arr);

            // DB::commit();

         return response()->json([
                'success' => true,
                'message' => 'created successfully.'
            ]);

        } catch (\Exception $e) {
           return response()->json([
                'success' => false,
                'errors' => ['server' => [$e->getMessage()]]
            ]);

           
        }

    }

    public function feedbackoption_edit($id)
    {
        $editfeedoption = FeedbackOption::findOrFail(base64_decode($id)); 

        return view('admin.feedback-option.edit', compact('editfeedoption'));
    }


    public function feedbackoption_update(Request $request)
    {
        $id = base64_decode($request->id);

        $rules = [
            'name'       =>'required|unique:feedback_options,name,'.$id,
            
        ];

        $messages = [
            'name.required'  => 'Name is required.',
            'name.unique'    =>'This name already exists.',
        ];

        $validation = Validator::make($request->all(), $rules, $messages);

        if ($validation->fails()) {
            return redirect()->back()->withErrors($validation)->withInput();
        }

        // DB::beginTransaction();

        try {
            $feedbackoption = FeedbackOption::findOrFail($id);

            $feedbackoption->name  = $request->name;
            $feedbackoption->status = $request->status;
          
            $feedbackoption->save();

            // DB::commit();

            return response()->json([
                'success' => true,
                'message' => 'Feedback Option updated successfully.'
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'errors' => ['server' => [$e->getMessage()]]
            ]);
        }


    }


    public function feedbackoption_delete(Request $request)
    {
        try {
            $id = base64_decode($request->id);
            $student = FeedbackOption::findOrFail($id);
            $student->delete();
    
            return response()->json(['success' => true, 'message' => 'FeedbackOption deleted successfully']);
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => $e->getMessage()]);
        }
    }
    
       
        public function feedbackoptionStatus(Request $request)
        {
            $stu_id=base64_decode($request->id);
            $type = base64_decode($request->type);
        
            if($type == 'disable')
            { 
                $user = FeedbackOption::find($stu_id);
                $user->status = '0';
                $user->save();
                
                return response()->json([
                    'success'=>true,
                    'type' => $type,
                    'message'=>'Status change successfully.'
                ]);
            }
            elseif($type == 'enable')
            {   
                $user = FeedbackOption::find($stu_id);
                $user->status = '1';
                $user->save();
            
                return response()->json([
                    'success'=>true,
                    'type' => $type,
                    'message'=>'Status change successfully.'
                ]);
            }
        }


}
