<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Feedback;
use App\Models\User;
use App\Models\Subscription;
use App\Models\Admin;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use DB;
use Auth;

class HomeController extends Controller
{
     public function dashboard()
    {
        $activeuser = Admin::where('status', '1')->count();
        $allusers = Admin::all()->count();

        $subscribedUsers = Subscription::join('users', 'subscriptions.user_id', '=', 'users.id')
        ->where('status', 'active')
        ->distinct('subscriptions.user_id')
        ->count();

        $activeUserIds = Subscription::where('status', 'active')
        ->pluck('user_id')
        ->toArray();
        $unsubscribedUsers = User::whereNotIn('_id', $activeUserIds)->count();
       
        return view('admin.dashboard', compact('activeuser','allusers','subscribedUsers','unsubscribedUsers'));

    }
}
