<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Subscription;

class RevenueController extends Controller
{
    public function index(Request $request)
    {
        $query = Subscription::with('user','plan')->latest();

        if ($request->filled('search')) {
            $search = $request->search;
            $query->whereHas('user', function ($query) use ($search) {
                $query->where('name', 'like', '%' . $search . '%')
                 ->orWhere('email', 'like', '%' . $search . '%');
            });
            // ->whereHas('plan', function ($query) use ($planTitle) {
            //     $query->where('title', 'like', '%' . $planTitle . '%');
            // });
        }

        $list = $query->paginate(10);

        if ($request->ajax()) {
            return view('admin.revenue.list', compact('list'))->render();
        }

        $totalAmount = Subscription::where('payment_status', 1)->sum('amount');

        return view('admin/revenue/index', compact('list','totalAmount'));
    }
}
