<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\SampleQuestion;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;
use DB;

class SampleQuestionController extends Controller
{

    public function index(Request $request){

        // $questions = SampleQuestion::orderBy('created_at', 'desc')->paginate(10);
       
        // return view('admin.sample_questions.index', compact('questions'));

         $query = SampleQuestion::orderBy('created_at', 'desc');
        
        if ($request->filled('search')) {
            $search = $request->search;
            $query->where('question', 'like', '%' . $search . '%');
                    
        }
        $questions  = $query->paginate(10);

        if ($request->ajax()) {
            return view('admin.sample_questions.ajax', compact('questions'))->render();
        }
        return view('admin.sample_questions.index', compact('questions'));
    }

    public function store(Request $request){
        $rules = [
             'question' => 'required|unique:sample_questions,question',

        ];

         $messages = [
            'question.required'     =>'Question is required.',
            'question.unique'       =>'This question already exists.',
              
        ];
      
        $validation = Validator::make($request->all(), $rules, $messages);
        if ($validation->fails()) {

            return response()->json([
                'success' => false,
                'errors' => $validation->errors()
            ]);
        }
        // DB::beginTransaction();
        try{
           
            $insert_arr = array(
            'question'         =>$request->question,
            'created_at'       => Carbon::now(),
            );
            
            $insert = SampleQuestion::insert($insert_arr);
    
            // DB::commit();
            return response()->json([
                'success' => true,
                'message' => 'created successfully.'
            ]);

        } catch (\Exception $e) {
           return response()->json([
                'success' => false,
                'errors' => ['server' => [$e->getMessage()]]
            ]);

           
        }

    }

    public function samplequestions_edit($id)
    {
        $data = SampleQuestion::findOrFail($id);
        $html = view('admin.sample_questions.edit', compact('data'))->render();

        return response()->json([
            'html' => $html
        ]);
    }


    // public function samplequestions_edit(Request $request){
       
    //     $id = $request->id;
       
    //     $data=SampleQuestion::where(['id'=>$id])->first();
    //     $html=view('admin.sample_questions.edit')->with([ 'data' => $data])->render();
   
    //     return response()->json(['html' => $html]);
    // }

    public function samplequestions_update(Request $request)
    {
        $id = base64_decode($request->id);
      
        $rules = [
            'editquestion' => 'required|unique:sample_questions,question',
                
        ];

        $messages = [
            'editquestion.required'     =>'Question is required.',
            'editquestion.unique'       =>'This question already exists.',
              
        ];
       
         $validation = Validator::make($request->all(), $rules, $messages);
        if ($validation->fails()) {

            return response()->json([
                'success' => false,
                'errors' => $validation->errors()
            ]);
        }
        // DB::beginTransaction();
        try{
    
            $samplequestion = SampleQuestion::find($id);

            if (!$samplequestion) {
                return redirect()->back()->with('error', 'SampleQuestion not found');
            }
            $samplequestion->question = $request->editquestion;
           
            $samplequestion->updated_at = Carbon::now();
            $samplequestion->save();

             return response()->json([
                'success' => true,
                'message' => 'Updated successfully.'
            ]);

        } catch (\Exception $e) {
           return response()->json([
                'success' => false,
                'errors' => ['server' => [$e->getMessage()]]
            ]);

           
        }
      
    }

    public function samplequestions_delete(Request $request){
       
        $id=$request->id;
        try {
            $samplequestion = SampleQuestion::findOrFail($id);
            $samplequestion->delete();

            return response()->json(['message' => 'Sample question deleted successfully'], 200);
        }
        catch (\Exception $e) {
            return response()->json(['error' => 'Unable to soft delete item'], 500);
        }
    }

   
}
