<?php

namespace App\Models;

use Illuminate\Auth\Authenticatable;
use Illuminate\Contracts\Auth\Authenticatable as AuthenticatableContract;
use Illuminate\Notifications\Notifiable;
// use Laravel\Sanctum\HasApiTokens;
// use Spatie\Permission\Traits\HasRoles;
use App\Models\Permission;
use App\Models\Role;

// use Illuminate\Database\Eloquent\Model;
use MongoDB\Laravel\Eloquent\Model as Eloquent;

class Admin extends Eloquent implements AuthenticatableContract
{
    use Authenticatable, Notifiable ; //, HasRoles;

    // protected $guard = 'admin';

    protected $fillable = ['name', 'email', 'password','status','image','role_id'];

    // protected $hidden = ['password'];

    // protected $casts = ['email_verified_at' => 'datetime'];

    protected $guarded = [];

    public function role()
    {
        return $this->belongsTo(Role::class,'role_id','id');
    }

    public function hasPermission(string $slug): bool
    {
        $role = $this->role;
        if (!$role) return false;

        $permissions = Permission::whereIn('_id', $role->permission_ids ?? [])->pluck('slug')->toArray();
        return in_array($slug, $permissions);
    }
    
}
