<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
// use Illuminate\Database\Eloquent\Model;
use MongoDB\Laravel\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ChatRoom extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'user_id',
        'chat_id',
        'subject_id',
        'name',
        'is_deleted',
    ];

    protected $dates = ['deleted_at'];

    // Relationship with User
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
