<?php

namespace App\Models;

// use Illuminate\Database\Eloquent\Model;
use MongoDB\Laravel\Eloquent\Model as Model;
use Laravel\Sanctum\Contracts\HasAbilities;

class PersonalAccessToken extends Model implements HasAbilities
{
    protected $collection = 'personal_access_tokens';

    protected $guarded = [];

    // protected $casts = [
    //     'abilities' => 'array',
    //     'last_used_at' => 'datetime',
    //     'expires_at' => 'datetime',
    // ];

    public function tokenable()
    {
        return $this->morphTo();
    }

    public function can($ability)
    {
        return in_array($ability, $this->abilities ?? []);
    }

    public function cant($ability)
    {
        return !$this->can($ability);
    }

    public static function findToken($token)
    {
        $model = new static;

        $token = hash('sha256', $token);

        return $model->where('token', $token)->first();
    }
}
