<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
// use Illuminate\Database\Eloquent\Model;
use MongoDB\Laravel\Eloquent\Model;
// use App\Models\UsagesLimit;

class Plan extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'price', 'interval', 'points'];

    protected $casts = [
        'points' => 'array', // Automatically handle JSON as an array
    ];

    // public function getPointsAttribute($value)
    // {
    //     return json_decode($value) ?? [];
    // }

    public function usageLimit()
    {
        return $this->belongsTo(UsageLimit::class, 'ul_id', 'id');
    }
}
