<?php

namespace App\Models;

// use Illuminate\Database\Eloquent\Model;
use MongoDB\Laravel\Eloquent\Model;

class Subscription extends Model
{
    protected $fillable = ['user_id', 'stripe_subscription_id', 'plan_id', 'status'];

    // Subscription belongs to a User
    public function user()
    {
        return $this->belongsTo(User::class,'user_id','id');
    }

    // Subscription belongs to a Plan
    public function plan()
    {
        return $this->belongsTo(Plan::class,'plan_id','id');
    }
}
