<?php

namespace App\Models;

use Illuminate\Auth\Authenticatable;
// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
// use Illuminate\Foundation\Auth\User as Authenticatable;
// use MongoDB\Laravel\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\SoftDeletes;
// use Laravel\Sanctum\HasApiTokens;
// use App\Traits\HasMongoApiTokens;
// use Spatie\Permission\Traits\HasRoles;
// use App\Notifications\CustomResetPasswordNotification;
// use Illuminate\Auth\Notifications\ResetPassword as ResetPasswordNotification;
use MongoDB\Laravel\Relations\HasMany;


use Illuminate\Contracts\Auth\Authenticatable as AuthenticatableContract;
use MongoDB\Laravel\Eloquent\Model as Eloquent;

class User extends Eloquent implements AuthenticatableContract
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use Authenticatable, HasFactory, Notifiable, SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'dob',
        'otp',
        'otp_expires_at',
        'is_email_verified',
        'status',
        'dob',
        'parent_email',
        'avatar',
        'parent_name',
        'frequency',
        'is_social_login',
        'social_id',
        'social_type'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    // protected $hidden = [
    //     'password',
    //     'remember_token',
    // ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }

    // public function sendPasswordResetNotification($token)
    // {
    //     $this->notify(new CustomResetPasswordNotification($token));
    // }

    public function subscriptions(): HasMany
    {
        return $this->hasMany(Subscription::class,'user_id','id');
    }

    public function subscriptionPlan(): ?Subscription
    {
        return $this->subscriptions()
                    ->where('status', 'active')
                    ->latest()
                    ->first();
    }
}
