<?php

namespace App\Queue\Connectors;

use Illuminate\Queue\Connectors\ConnectorInterface;
use App\Queue\MongoDatabaseQueue;

class MongoConnector implements ConnectorInterface
{
    public function connect(array $config)
    {
        $connection = app('mongodb'); // MongoDB\Laravel\Connection
        $client = $connection->getMongoClient(); // ✅ Extract the raw MongoDB\Client

        return new MongoDatabaseQueue(
            $client,                                 // ✅ now correct type
            $config['collection'] ?? 'jobs',
            $config['queue'] ?? 'default'
        );
    }
}