<?php

namespace App\Queue;

use Illuminate\Queue\Jobs\Job;

class MongoJob extends Job
{
    protected $jobData;
    protected $queue;

    public function __construct($container, $queueInstance, $jobData, $queue)
    {
        $this->container = $container;
        $this->job = $jobData['payload'];
        $this->jobData = $jobData;
        $this->queue = $queueInstance;
        $this->queueName = $queue;
    }

    public function fire()
    {
        $payload = $this->payload();
        $this->resolveAndFire($payload);
    }

    public function delete()
    {
        parent::delete();
        $this->queue->getCollection()->deleteOne(['_id' => $this->jobData['_id']]);
    }

    public function attempts()
    {
        return $this->jobData['attempts'];
    }

    public function getRawBody()
    {
        return $this->job;
    }
}
