<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
use App\Http\Middleware\SetDefaultSession;
use App\Http\Middleware\AuthenticateWithToken;
use Laravel\Sanctum\Http\Middleware\EnsureFrontendRequestsAreStateful;
use Illuminate\Routing\Middleware\SubstituteBindings;

use App\Providers\MongoQueueServiceProvider;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        api: __DIR__.'/../routes/api.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
        // $middleware->append([
        //     EnsureFrontendRequestsAreStateful::class, // Sanctum authentication
        //     SubstituteBindings::class, // Fixes route model binding issues
        // ]);
        $middleware->append([
            \Illuminate\Session\Middleware\StartSession::class,
            // SetDefaultSession::class,
        ]);
        
        $middleware->append(\Illuminate\Http\Middleware\HandleCors::class); // CORS Middleware
        $middleware->alias([
            // 'role' => \Spatie\Permission\Middleware\RoleMiddleware::class,
            // 'permission' => \Spatie\Permission\Middleware\PermissionMiddleware::class,
            // 'role_or_permission' => \Spatie\Permission\Middlewares\RoleOrPermissionMiddleware::class,
            'permission' => \App\Http\Middleware\CheckPermission::class,
        ]);
    })
    // ->withMiddleware(function (Middleware $middleware) {
    //     $middleware->alias([
    //         'auth:sanctum' => EnsureFrontendRequestsAreStateful::class,
    //     ]);
    //     $middleware->appendToGroup('api', SubstituteBindings::class);
    // })
    ->withMiddleware(function (\Illuminate\Foundation\Configuration\Middleware $middleware) {
        // Register global or route middleware groups
        $middleware->alias([
            'auth.token' => AuthenticateWithToken::class,
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })->withProviders([
        MongoQueueServiceProvider::class,
        MongoDB\Laravel\MongoDBBusServiceProvider::class
    ])->create();
    