<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('chats', function (Blueprint $table) {
            $table->id();
            $table->string('user_id',400)->nullable();
            $table->string('c_id',400)->nullable();
            $table->string('ai_personality',400)->nullable();
            $table->string('audio_format',20)->nullable();
            $table->tinyInteger('tts')->unsigned()->nullable(); 
            $table->longText('text')->nullable();
            $table->longText('audio_base64')->nullable();
            $table->longText('images_base64')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('chats');
    }
};
