<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Schema::table('chat_rooms', function (Blueprint $table) {
        //     $table->unsignedBigInteger('subject_id')->nullable()->after('name'); // Adjust position as needed

        //     // If 'subjects' table exists and subject_id is a foreign key
        //     $table->foreign('subject_id')->references('id')->on('subject_masters')->onDelete('set null');
        // });

        Schema::table('chat_rooms', function (Blueprint $table) {
            $table->unsignedBigInteger('subject_id')->nullable(); //->after('name') ne need in mongodb
        });

        Schema::table('chat_rooms', function (Blueprint $table) {
            $table->foreign('subject_id')
                ->references('id')
                ->on('subject_masters')
                ->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('chat_rooms', function (Blueprint $table) {
            $table->dropForeign(['subject_id']); // Drop foreign key first
            $table->dropColumn('subject_id');
        });
    }
};
