<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('account_delete_requests', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('user_id')->nullable();
            $table->string('name');
            $table->string('email');
            $table->tinyInteger('is_email_verified')->unsigned()->default(0);
            $table->timestamp('email_verified_at')->nullable();
            $table->string('parent_email',100)->nullable();
            $table->string('parent_name',400)->nullable();
            $table->string('frequency',400)->nullable();
            $table->string('avatar',400)->nullable();
            $table->tinyInteger('status')->unsigned()->default(1);
            $table->dateTime('dob')->nullable();    
            $table->unsignedInteger('otp')->nullable();
            $table->timestamp('otp_expires_at')->nullable();
            $table->string('password');
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('account_delete_requests');
    }
};
