<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('chats', function (Blueprint $table) {
            $table->longText('graph_base64')->nullable(); //->after('images_base64') no need in mongodb
            $table->boolean('feedback')->nullable()->default(null); //->after('graph_base64') no need in mongodb
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('chats', function (Blueprint $table) {
            $table->dropColumn('graph_base64');
            $table->dropColumn('feedback');
        });
    }
};
