<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('subscriptions', function (Blueprint $table) {
            $table->string('session_id',800)->nullable(); // ->after('user_id') no need in mongodb
            $table->tinyInteger('payment_status')->unsigned()->default(0); // ->after('status') no need in mongodb
            $table->string('transaction_id')->nullable(); // ->after('payment_status') no need in mongodb
            $table->string('amount')->nullable(); // ->after('transaction_id') no need in mongodb
            $table->timestamp('start_at')->nullable(); // ->after('amount') no need in mongodb
            $table->timestamp('end_at')->nullable(); // ->after('start_at') no need in mongodb
            $table->tinyInteger('is_trial')->unsigned()->default(0); // ->after('end_at') no need in mongodb
            $table->text('log')->nullable(); // ->after('is_trial') no need in mongodb
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('subscriptions', function (Blueprint $table) {
            $table->dropColumn([
                'session_id',
                'transaction_id',
                'amount',
                'start_at',
                'end_at',
                'is_trial',
                'log',
            ]);
        });
    }
};
