<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('usage_limits', function (Blueprint $table) {
            $table->id();
            $table->string('word_limit',255);
            $table->string('word_limit_durection'); // e.g. 'daily', 'monthly'
            $table->string('voice_limit',255)->comment('in minutes');
            $table->string('voice_limit_durection');
            $table->string('image_limit',225);
            $table->string('image_limit_durection');
            $table->integer('device_limit');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('usage_limits');
    }
};
