@extends('layouts.admin')
@section('title', 'Subject Management')
@section('content')

<div class="dashboard-content bg-light p-4 mt-5">
    <div class="content-card rounded-2 bg-white p-4 mt-4">

    <div class="container mt-5">
    <h2>Sample Questions</h2>
    <button class="btn btn-primary mb-3" data-bs-toggle="modal" data-bs-target="#questionModal" onclick="openAddModal()">Add Question</button>

    <table class="table table-bordered" id="questionTable">
        <thead>
            <tr>
                <th>ID</th>
                <th>Question</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($questions as $question)
                <tr id="row-{{ $question->id }}">
                    <td>{{ $question->id }}</td>
                    <td>{{ $question->question }}</td>
                    <td>
                        <button class="btn btn-sm btn-warning" onclick="openEditModal({{ $question->id }})">Edit</button>
                        <button class="btn btn-sm btn-danger" onclick="deleteQuestion({{ $question->id }})">Delete</button>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>

<!-- Modal -->
<div class="modal fade" id="questionModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <form id="questionForm">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add/Edit Question</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" id="questionId">
                    <div class="mb-3">
                        <label for="question" class="form-label">Question</label>
                        <input type="text" class="form-control" id="question" name="question" required>
                         <p class="text-danger" id="error-question"></p>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Save Question</button>
                </div>
            </div>
        </form>
    </div>
</div>
     
</div>  
</div>


<script>
    let modal = new bootstrap.Modal(document.getElementById('questionModal'));

    function openAddModal() {
        $('#questionId').val('');
        $('#question').val('');
    }

    function openEditModal(id) {
        $.get('/abc' + id, function(data) {
            $('#questionId').val(data.id);
            $('#question').val(data.question);
            modal.show();
        });
    }

    $('#questionForm').submit(function(e) {
        e.preventDefault();
        let id = $('#questionId').val();
        let url = id ? '/sample-questions/' + id : '/sample-questions';
        let type = id ? 'PUT' : 'POST';

        $.ajax({
            url: url,
            type: type,
            data: {
                question: $('#question').val(),
                _token: '{{ csrf_token() }}',
                ...(id && { _method: 'PUT' })
            },
            success: function(response) {
                location.reload();
            },
            error: function(xhr) {
                alert('Error occurred');
            }
        });
    });

    function deleteQuestion(id) {
        if (confirm('Are you sure you want to delete this question?')) {
            $.ajax({
                url: '/sample-questions/' + id,
                type: 'DELETE',
                data: { _token: '{{ csrf_token() }}' },
                success: function() {
                    $('#row-' + id).remove();
                },
                error: function() {
                    alert('Failed to delete.');
                }
            });
        }
    }
</script>

@endsection 
