@extends('layouts.admin')
@section('title', 'Billing Management')
@section('content')


<div class="dashboard-content bg-light p-4 mt-5">
    <div class="content-card rounded-2 bg-white p-4 mt-lg-4 mt-md-4 mt-1">
        <!-- <div class="row align-items-center">
            <div class="col-md-12">
                <p><a href="#" class="text-dark text-decoration-none position-relative"><i class="fa-solid fa-chevron-left me-2"></i> Edit Subscription</a></p>
            </div>
        </div>   -->
        <div class="row mt-lg-4 mt-md-0 mt-0">
            <div class="col-md-12">
                <form id="updatebill" action="{{ route('admin.billing.update') }}" method="POST" class="add-user-form p-4" enctype="multipart/form-data"> 
                    @csrf
                    <input type="hidden" name="id" value="{{ base64_encode($billing->id) }}">
                    <div class="row">
                        <div class="col-md-6">
                            <label for="#" class="form-label">Plan Name<span class="text-danger">*</span></label>
                            <input type="text" class="form-control rounded-pill" id="p-name" value="{{ $billing->name }}" name="name">    
                            <p class="text-danger" id="error-name"></p>
                        </div>

                        <div class="col-md-6 mt-lg-0 mt-md-0 mt-4">
                            <label for="#" class="form-label">Billing Period<span class="text-danger">*</span></label>
                            <select class="form-select form-control rounded-pill" name="interval" id="b-period">
                                <option value="month" {{ ($billing->interval == 'month') ? 'selected' : '' }}>Month</option>
                                <option value="year" {{ ($billing->interval == 'year') ? 'selected' : '' }}>Year</option>
                            </select>  
                            <p class="text-danger" id="error-interval"></p>
                        </div>
                    </div>
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <label for="#" class="form-label">Amount<span class="text-danger">*</span></label>
                            <input type="text" class="form-control rounded-pill" id="amount" value="{{ $billing->price }}" name="price">    
                             <p class="text-danger" id="error-price"></p>
                        </div>
                        <div class="col-md-6 mt-lg-0 mt-md-0 mt-4">
                            <label for="#" class="form-label">Note</label>
                            <input type="text" class="form-control rounded-pill" id="note" value="{{ $billing->note }}" placeholder="" name="note">    
                            <!-- <p class="text-danger" id="error-note"></p> -->
                        </div>
                    </div>
                    {{-- <div class="row mt-4">
                        <div class="col-md-12">
                            <label for="features" class="form-label">Features<span class="text-danger">*</span></label>
                            <div class="border p-4 rounded-4">
                                <div class="row">
                                    <div class="col-md-6">
                                        <ul class="subscription-card-ul p-0 mb-0">
                                            <li class="d-flex gap-2 py-1 align-items-center">
                                                <span><i class="fa-solid fa-circle-check"></i></span>
                                                <span class="subscription-cardSpan2">Access to basic math problems & quizzes</span>
                                            </li>
                                            <li class="d-flex gap-2 py-1 align-items-center">
                                                <span><i class="fa-solid fa-circle-check"></i></span>
                                                <span class="subscription-cardSpan2">Limited daily attempts for quizzes</span>
                                            </li>
                                            <li class="d-flex gap-2 py-1 align-items-center">
                                                <span><i class="fa-solid fa-circle-check"></i></span>
                                                <span class="subscription-cardSpan2">Basic progress tracking</span>
                                            </li>
                                        </ul>
                                    </div>
                                    
                                </div>
                            </div>
                        </div>
                    </div> --}}

                    <div class="row mt-4">
                        <div class="col-md-12">
                            <label for="features" class="form-label">Features <span class="text-danger">*</span></label>
                            <div class="border p-4 rounded-4">
                                <div id="features-section">
                                    @php
                                        $features = isset($billing->points) ? json_decode($billing->points, true) : [];
                                      
                                    @endphp
                    
                                    @if (!empty($features))
                                        <div id="additional-feature-fields">
                                            @foreach ($features as $index => $feature)
                                           
                                                <div class="row mb-3 feature-row">
                                                    <div class="col-md-6">
                                                        <input type="text" name="features_text[]" class="form-control" value="{{ $feature['text'] ?? '' }}" placeholder="Enter Feature Description">
                                                         
                                                         <p class="text-danger error-message" id="features_text_{{ $index }}_error"></p>
                                                    </div>
                                                      
                                                    <div class="col-md-3 mt-lg-0 mt-md-0 mt-4">
                                                        <select name="features_mark[]" class="form-select form-control rounded-2">
                                                            <option value="1" {{ isset($feature['mark']) && $feature['mark'] == 1 ? 'selected' : '' }}>Yes</option>
                                                            <option value="0" {{ isset($feature['mark']) && $feature['mark'] == 0 ? 'selected' : '' }}>No</option>
                                                        </select>
                                                         <p class="text-danger error-message" id="features_mark_{{ $index }}_error"></p>
                                                    </div>
                                                   
                                                    <div class="col-md-3 d-flex align-items-center mt-lg-0 mt-md-0 mt-4">
                                                        @if ($index == 0)
                                                            <button type="button" class="btn btn-primary add-feature">Add More</button>
                                                        @else
                                                            <button type="button" class="btn btn-danger remove-feature">Remove</button>
                                                        @endif
                                                    </div>
                                                </div>
                                                
                                            @endforeach
                                        </div>
                                    @else
                                        <div class="row mb-3 feature-row">
                                            <div class="col-md-6">
                                                <input type="text" name="features_text[]" class="form-control" placeholder="Enter Feature Description">
                                            </div>
                                            <div class="col-md-3 mt-lg-0 mt-md-0 mt-4">
                                                <select name="features_mark[]" class="form-select form-control rounded-2">
                                                    <option value="1">Yes</option>
                                                    <option value="0">No</option>
                                                </select>
                                            </div>
                                            <div class="col-md-3 d-flex align-items-center mt-lg-0 mt-md-0 mt-4">
                                                <button type="button" class="btn btn-primary add-feature">Add More</button>
                                            </div>
                                        </div>
                                        <div id="additional-feature-fields"></div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mt-5">
                        <div class="col-md-6">
                            <button class="btn add-btn px-4 py-3 w-100 rounded-pill">Save</button>
                        </div>
                        <!-- <div class="col-md-6">
                            <button class="btn cancel-btn px-4 py-3 w-100 rounded-pill">Disable Plan</button>
                        </div> -->
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
{{-- <script>
    document.addEventListener('DOMContentLoaded', function () {
        document.querySelector('.add-feature')?.addEventListener('click', function () {
            const html = `
                <div class="row mb-3 feature-row">
                    <div class="col-md-6">
                        <input type="text" name="features_text[]" class="form-control" placeholder="Enter Feature Description">
                        <p class="text-danger error-message" id="error-features_text_{{ $index }}"></p>
                    </div>
                    <div class="col-md-3">
                        <select name="features_mark[]" class="form-select">
                            <option value="1">Yes</option>
                            <option value="0">No</option>
                        </select>
                    </div>
                    <div class="col-md-3 d-flex align-items-center">
                        <button type="button" class="btn btn-danger remove-feature">Remove</button>
                    </div>
                </div>
            `;
            document.getElementById('additional-feature-fields').insertAdjacentHTML('beforeEnd', html);
        });
    
        document.addEventListener('click', function (e) {
            if (e.target.classList.contains('remove-feature')) {
                e.target.closest('.feature-row').remove();
            }
        });
    });
</script> --}}

<script>
    document.addEventListener('DOMContentLoaded', function () {
        let featureIndex = document.querySelectorAll('.feature-row').length;

        document.querySelector('.add-feature')?.addEventListener('click', function () {
            const html = `
                <div class="row mb-3 feature-row">
                    <div class="col-md-6">
                        <input type="text" name="features_text[]" class="form-control" placeholder="Enter Feature Description">
                        <p class="text-danger error-message" id="features_text_${featureIndex}_error"></p>
                    </div>
                    <div class="col-md-3">
                        <select name="features_mark[]" class="form-select">
                            <option value="1">Yes</option>
                            <option value="0">No</option>
                        </select>
                        <p class="text-danger error-message" id="features_mark_${featureIndex}_error"></p>
                    </div>
                    <div class="col-md-3 d-flex align-items-center">
                        <button type="button" class="btn btn-danger remove-feature">Remove</button>
                    </div>
                </div>
            `;
            document.getElementById('additional-feature-fields').insertAdjacentHTML('beforeEnd', html);
            featureIndex++;
        });

        document.addEventListener('click', function (e) {
            if (e.target.classList.contains('remove-feature')) {
                e.target.closest('.feature-row').remove();
            }
        });
    });
</script>


<script>
    $('#updatebill').on('submit', function(e) {
        e.preventDefault();
    
        $('#submitBtn').attr('disabled', true);
        $('small').text('');
        $('#successMessage').text('');
    
        $.ajax({
            url: '{{ route('admin.billing.update') }}',
            method: 'POST',
            data: $(this).serialize(),
            success: function(response) {
                $('#submitBtn').attr('disabled', false);
                showAlert(response.message,'s');
                $('#updatebill')[0].reset();
            },
            error: function(xhr) {
                $('#submitBtn').attr('disabled', false);

                if(xhr.status == 422) {
                    let errors = xhr.responseJSON.errors;
                    
                    // Clear all old errors first
                    $('.error-message').text('');

                    $.each(errors, function(key, messages) {
                        // Handle nested array keys like 'features_text.0'
                        let formattedKey = key.replace(/\./g, '_');
                        $('#' + formattedKey + '_error').text(messages[0]);
                    });
                }
            }
        });
    });
</script>
    

@endsection