@extends('layouts.admin')
@section('title', 'Billing Management')
@section('content')
  @php
    $authCheck = auth()->check();
    $permission= auth()->user();
@endphp

<div class="dashboard-content bg-light p-4 mt-5">
    <div class="content-card rounded-2 bg-white p-4 mt-lg-4 mt-md-4 mt-1">
        <div class="row align-items-center">

            {{-- <div class="col-md-6">
                <div class="d-flex gap-3">
                   
                    <div class="search-div">
                        <form>
                            <div class="input-group">
                                <span class="input-group-text bg-white"><a href="#" class="text-dark"><i class="fa-solid fa-magnifying-glass"></i></a></span>
                                <input type="text" class="form-control border-start-0" placeholder="Search User">
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="d-flex gap-3">
                    <!-- <a href="add-user.html" class="btn add-btn px-4 py-2">Add Users</a> -->
                    <div>
                        <form>
                            <div class="input-group">
                                <span class="input-group-text bg-white"><a href="#" class="text-dark"><i class="fa-solid fa-magnifying-glass"></i></a></span>
                                <input type="text" class="form-control border-start-0" placeholder="Search User">
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="col-md-6 mt-lg-0 mt-md-0 mt-4">
                <div class="d-flex justify-content-between">
                    <form class="row align-items-center w-100">
                        <div class="col-lg-6 col-md-6 col-6">
                            <div class="input-group">
                                <input type="text" class="form-control border-end-0" placeholder="Sort">
                                <span class="input-group-text bg-white"><a href="#" class="text-dark"><i class="fa-solid fa-arrow-up"></i></a><a href="#" class="text-dark"><i class="fa-solid fa-arrow-down"></i></a></span>
                            </div>
                        </div>
                        <div class="col-lg-5 col-md-5 col-5">
                            <select class="form-control form-select" name="" id="">
                                <option value="filter">Filter</option>
                                <option value="value1">Value 1</option>
                            </select>
                        </div>
                        <div class="col-lg-1 col-md-1 col-1">
                            <a href="#" class="text-dark"><i class="fa-solid fa-arrows-spin"></i></a>
                        </div>
                    </form>
                </div>
            </div> --}}
        </div>  
        <div class="row mt-4">
            <div class="col-md-12">
                
                <div class="table-responsive user-table student-table">
                    <table class="table table-striped">
                        <thead class="border-bottom">
                            <tr>
                                <th>S.No.</th>
                                <th>Plan Name</th>
                                <th>Billing Period</th>
                                <th>Amount</th>
                                <th>Features</th> 
                                <th>Actions</th> 
                            </tr>
                        </thead>
                       
                        <tbody>
                            @foreach($billings as $key => $billing)
                            <tr>
                            @php
                                $points = json_decode($billing->points);
                            @endphp

                                <td>{{ $key + 1 }}</td>
                                <td>{{ $billing->name }}</td>
                                <td>{{ $billing->interval }}</td>
                                <td>{{ $billing->price }}</td>
                                <td>
                                   
                                    @if(is_array($points))
                                        <ul class="mb-0">
                                            @foreach($points as $point)
                                               <li>
                                                    {{ \Illuminate\Support\Str::limit($point->text,100) }} {{ $point->mark == 1 ? '' : '' }}
                                                </li>
                                            @endforeach
                                        </ul>
                                    @else
                                        {{ $billing->points }}
                                    @endif
                                </td>

                                <td class="">
                                     @if($authCheck && $permission->hasPermission('billing-edit'))
                                    <a href="{{ route('admin.billing.edit', base64_encode($billing->id)) }}" class="text-success text-decoration-none me-2" data-bs-toggle="tooltip" data-bs-placement="top" title="Edit">
                                        <i class="fa-solid fa-pen-to-square"></i>
                                    </a> 
                                    @endif

                                    <!-- @if($authCheck && $permission->hasPermission('billing-delete'))
                                    <a href="javascript:void(0);" 
                                        class="text-danger me-2 delete-btn text-decoration-none" 
                                        data-bs-toggle="tooltip" data-bs-placement="top" title="Delete"
                                        data-id="{{ base64_encode($billing->id) }}">
                                            <i class="fa-solid fa-trash"></i>
                                    </a>
                                    @endif -->
                                </td>
                            </tr>

                            @endforeach
                          
                        </tbody>
                    </table>
                </div>
             
            </div>
        </div>
    </div>  
</div>

<script>
$(document).on('click', '.delete-btn', function () {
    var itemId = $(this).data('id');

    Swal.fire({
        title: 'Are you sure?',
        text: "You won't be able to revert this!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: "{{ route('admin.billing.delete') }}",
                type: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    id: itemId
                },
                success: function (response) {
                    Swal.fire(
                        'Deleted!',
                        'The billing has been deleted.',
                        'success'
                    ).then(() => {
                        location.reload();
                    });
                },
                error: function (xhr) {
                    Swal.fire(
                        'Error!',
                        'Something went wrong.',
                        'error'
                    );
                }
            });
        }
    });
});
</script>


@endsection
