@extends('layouts.admin')
@section('title', 'Contact Management')
@section('content')
@php
    $authCheck = auth()->check();
    $permission= auth()->user();
 @endphp
<div class="dashboard-content bg-light p-4 mt-5">
    <div class="content-card rounded-2 bg-white p-4 mt-lg-4 mt-md-4 mt-1">
        <div class="row align-items-center">

            <div class="col-md-12">
                <div class="d-flex gap-3">
                
                    <div class="search-div">
                        <form>
                            <div class="input-group">
                                <span class="input-group-text bg-white"><a href="#" class="text-dark"><i class="fa-solid fa-magnifying-glass"></i></a></span>
                                <input type="text" class="form-control border-start-0" placeholder="Search User">
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            {{-- <div class="col-md-6">
                <div class="d-flex gap-3">
               
                    <div>
                        <form>
                            <div class="input-group">
                                <span class="input-group-text bg-white"><a href="#" class="text-dark"><i class="fa-solid fa-magnifying-glass"></i></a></span>
                                <input type="text" class="form-control border-start-0" placeholder="Search User">
                            </div>
                        </form>
                    </div>
                </div>
            </div> --}}
            {{-- <div class="col-md-6 mt-lg-0 mt-md-0 mt-4">
                <div class="d-flex justify-content-between">
                    <form class="row align-items-center w-100">
                        <div class="col-lg-6 col-md-6 col-6">
                            <div class="input-group">
                                <input type="text" class="form-control border-end-0" placeholder="Sort">
                                <span class="input-group-text bg-white"><a href="#" class="text-dark"><i class="fa-solid fa-arrow-up"></i></a><a href="#" class="text-dark"><i class="fa-solid fa-arrow-down"></i></a></span>
                            </div>
                        </div>
                        <div class="col-lg-5 col-md-5 col-5">
                            <select class="form-control form-select" name="" id="">
                                <option value="filter">Filter</option>
                                <option value="value1">Value 1</option>
                            </select>
                        </div>
                        <div class="col-lg-1 col-md-1 col-1">
                            <a href="#" class="text-dark"><i class="fa-solid fa-arrows-spin"></i></a>
                        </div>
                    </form>
                </div>
            </div> --}}
        </div>  
        <div class="row mt-4">
            <div class="col-md-12">
                <div class="table-responsive user-table student-table">
                    <table class="table table-striped">
                        <thead class="border-bottom">
                            <tr>
                                <th>S.No.</th>
                                <th>Full Name</th>
                                <th>Email</th>
                                <th>Subject</th>
                                <th>Actions</th> 
                            </tr>
                        </thead>
                       
                        <tbody>
                            @foreach($contacts as $key => $contact)
                            <tr>
                                <td>{{ $key + 1 }}</td>
                                <td>{{ $contact->full_name }}</td>
                                <td>{{ $contact->email }}</td>
                                <td>{{ $contact->subject }}</td>
                                @if($authCheck && $permission->hasPermission('contacts-show'))
                                    <td class="d-flex align-items-center">
                                        <a href="#" class="text-info view-details" data-id="{{ $contact->id }}" data-bs-toggle="tooltip" data-bs-placement="top" title="View"><i class="fa-solid fa-eye"></i></a>
                                    </td>
                                @endif
                            </tr>

                            @endforeach
                          
                        </tbody>
                    </table>
                </div>
               
            </div>
        </div>
    </div>  
</div>

<!-- Modal -->

<div class="modal fade" id="viewModal" tabindex="-1" aria-labelledby="viewModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg"> 
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="viewModalLabel">Message</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body" id="modalContent">
        <!-- Dynamic content will be loaded here -->
        <p>Message: gjnkxfn</p>
      </div>
    </div>
  </div>
</div>



<script>
    $(document).on('click', '.view-details', function(e) {
        e.preventDefault();

        var id = $(this).data('id');
        var url= "{{ route('admin.contact.view','-id-') }}";
        url = url.replace('-id-',id);

        $('#modalContent').html('<p>Loading...</p>'); // Temporary
        $('#viewModal').modal('show'); // Show the modal
        // alert(url);
        // Example AJAX (optional)
        $.ajax({
            url: url,
            type: "GET",
            success: function(response) {
            
                $('#modalContent').html(response.data.message); // Replace modal content
            
            },
            error: function() {
                $('#modalContent').html('<p class="text-danger">Failed to load data.</p>');
            }
        });
    });
</script>





@endsection
