 @php
    $authCheck = auth()->check();
    $permission= auth()->user();
@endphp
 <table class="table table-striped">
                        <thead class="border-bottom">
                            <tr>
                                <th>S.No.</th>
                                <th>Name</th>
                                <th>Status</th> 
                                <th>Actions</th> 
                            </tr>
                        </thead>
                       
                        <tbody>
                            @foreach($faqcategory as $key => $category)
                            <tr>
                                <td>{{ $key + 1 }}</td>
                                <td>{{ $category->name }}</td>
                                <!-- <td>{{ $category->status == 1 ? 'Active' : 'Inactive' }}</td> -->
                                 <td class="ms-2" id="statusLabel{{ $category->id }}">
                                    {{ $category->status == 1 ? 'Active' : 'Inactive' }}
                                 </td>
                                
                                <td class="d-flex align-items-center">
                                    
                                    <div class="lights">
                                        <div class="form-check form-switch mb-0 h-100">
                                            <input 
                                                class="form-check-input mt-0 change-status" 
                                                data-bs-toggle="tooltip" data-bs-placement="top" title="Status"
                                                type="checkbox" 
                                                id="statusSwitch{{ $category->id }}" 
                                                name="statusSwitch" 
                                                value="1"
                                                data-id="{{ base64_encode($category->id) }}"
                                                data-name="{{ $category->title }}"
                                                {{ $category->status == 1 ? 'checked' : '' }}
                                            >
                                             <!-- <label class="ms-2" id="statusLabel{{ $category->id }}">
                                                {{ $category->status == 1 ? 'Active' : 'Inactive' }}
                                            </label> -->
                                           
                                        </div>
                                    </div>
                                    @if($authCheck && $permission->hasPermission('faqcategory-edit'))
                                    <a href="{{ route('admin.faqcategory.edit', base64_encode($category->id)) }}" class="text-success me-2" data-bs-toggle="tooltip" data-bs-placement="top" title="Edit">
                                        <i class="fa-solid fa-pen-to-square"></i>
                                    </a> 
                                    @endif
                                    
                                    @if($authCheck && $permission->hasPermission('faqcategory-delete'))
                                    <a href="javascript:void(0);" 
                                        class="text-danger me-2 delete-btn" 
                                        data-bs-toggle="tooltip" data-bs-placement="top" title="Delete"
                                        data-id="{{ base64_encode($category->id) }}">
                                            <i class="fa-solid fa-trash"></i>
                                    </a>
                                    @endif
                                 
                                </td>

                              
                            </tr>


                            @endforeach
                          
                        </tbody>
                    </table>
                    <div class="pagination-wrapper mb-4">
                        {{ $faqcategory->links() }}
                    </div>