@extends('layouts.admin')
@section('title', 'Edit FAQ Category')
@section('content')
<div class="dashboard-content bg-light p-4 mt-5">
    <div class="content-card rounded-2 bg-white p-4 mt-lg-4 mt-md-4 mt-1">
        <div class="row mt-lg-4 mt-md-0 mt-0">
            <div class="col-md-12">
                <form id="UpdateFaqcategory" action="{{ route('admin.faqcategory.update') }}" method="POST" class="add-user-form p-4">
                    @csrf
                    <input type="hidden" name="id" value="{{ base64_encode($faqcategory->id) }}">
                    <div class="row">
                        <div class="col-md-6">
                            <label for="#" class="form-label">Name<span class="text-danger">*</span></label>
                            <input type="text" class="form-control rounded-2" id="f-name" value="{{ $faqcategory->name }}"name="name">    
                          <p class="text-danger" id="error-name"></p>
                        </div>
                       
                        <div class="col-md-6 mt-lg-0 mt-md-0 mt-4">
                            <label for="status" class="form-label">Status</label>
                            <select class="form-control rounded-2 form-select" name="status" id="status">
                                <option value="1" {{ $faqcategory->status == 1 ? 'selected' : '' }}>Active</option>
                                <option value="0" {{ $faqcategory->status == 0 ? 'selected' : '' }}>Inactive</option>
                            </select>
                            <p class="text-danger" id="error-status"></p>
                        </div>
                   
                    </div>
                   
                    <div class="row mt-5">
                        <div class="col-md-6">
                        <button type="submit" class="btn add-btn px-4 py-3 w-100 rounded-pill">Update</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<script>
     $(document).on('submit', 'form#UpdateFaqcategory', function(e) {
            e.preventDefault();

            var form = $(this);
            var formData = new FormData(this);

            $.ajax({
                url: form.attr('action'),
                method: form.attr('method'),
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    if (response.success) {
                        toastr.success(response.message || "Updated Successfully");

                        window.setTimeout(function() {
                            window.location.href = "{{ route('admin.faq-category') }}";
                        }, 2000);
                    } else if (response.errors) {

                        $.each(response.errors, function(key, error) {
                            var errorId = `#error-${key.replace('.', '_')}`;
                            $(errorId).html(error[0]);
                        });
                    } else {
                        alert("No changes were made.");
                    }
                },
                error: function(xhr) {
                    alert("An error occurred. Please try again.");
                    console.log(xhr.responseText);
                }
            });
        });
</script>
@endsection