@php
    $authCheck = auth()->check();
    $permission= auth()->user();
@endphp
<table class="table table-striped">
                        <thead class="border-bottom">
                            <tr>
                                <th>S.No.</th>
                                <th>Category</th>
                                <th>Question</th>
                                <th>Answer</th>
                                <th>Status</th> 
                                <th>Actions</th> 
                            </tr>
                        </thead>
                       
                        <tbody>
                            @foreach($faqs as $key => $faq)
                            <tr>
                                <td>{{ $key + 1 }}</td>
                                <td>{{ $faq->category->name }}</td>
                                <td class="text-justify">{{ Str::limit($faq->question,100,'...') }}</td>
                                <td class="text-justify">{{ Str::limit($faq->answer,100,'...') }}</td>
                                <td class="ms-2" id="statusLabel{{ $faq->id }}">
                                    {{ $faq->status == 1 ? 'Active' : 'Inactive' }}
                                </td>
                                
                                <td>
                                <div class="d-flex align-items-center">
                                    <div class="d-flex align-items-center">
                                        <div class="lights">
                                            <div class="form-check form-switch mb-0 h-100">
                                                <input 
                                                    class="form-check-input mt-0 change-status" 
                                                    data-bs-toggle="tooltip" data-bs-placement="top" title="Status"
                                                    type="checkbox" 
                                                    id="statusSwitch{{ $faq->id }}" 
                                                    name="statusSwitch" 
                                                    value="1"
                                                    data-id="{{ base64_encode($faq->id) }}"
                                                    data-name="{{ $faq->title }}"
                                                    {{ $faq->status == 1 ? 'checked' : '' }}
                                                >
                                                <!-- <label class="ms-2" id="statusLabel{{ $faq->id }}">
                                                    {{ $faq->status == 1 ? 'Active' : 'Inactive' }}
                                                </label> -->
                                            
                                            </div>
                                        </div>
                                    </div>

                                    <a href="{{ route('admin.faqs.edit', base64_encode($faq->id)) }}" class="text-success me-2" data-bs-placement="top" title="Edit">
                                        <i class="fa-solid fa-pen-to-square"></i>
                                    </a> 
                                    
                                    <a href="javascript:void(0);" 
                                        class="text-danger me-2 delete-btn" 
                                        data-id="{{ base64_encode($faq->id) }}" data-bs-placement="top" title="Delete">
                                            <i class="fa-solid fa-trash"></i>
                                    </a>
                                <div>                            
                                </td>

                              
                            </tr>

                            @endforeach
                          
                        </tbody>
                    </table>

                    <!-- Pagination Links -->
                    <div class="pagination-wrapper">
                        {{ $faqs->links() }}
                    </div>

<script>
    document.addEventListener("DOMContentLoaded", function () {
        const statusCells = document.querySelectorAll('[id^="statusLabel"]');

        // Initial color setting
        statusCells.forEach(function(cell) {
            const status = cell.textContent.trim().toLowerCase();

            if (status === 'active') {
                cell.classList.add('text-success');
                cell.classList.remove('text-danger');
            } else if (status === 'inactive') {
                cell.classList.add('text-danger');
                cell.classList.remove('text-success');
            }
        });

        // Handle status toggle without page refresh
        const switches = document.querySelectorAll('.change-status');

        switches.forEach(function (toggle) {
            toggle.addEventListener('change', function () {
                const studentId = this.getAttribute('data-id');
                const labelCell = document.getElementById('statusLabel' + atob(studentId)); // decode base64 id

                if (this.checked) {
                    labelCell.textContent = 'Active';
                    labelCell.classList.add('text-success');
                    labelCell.classList.remove('text-danger');
                } else {
                    labelCell.textContent = 'Inactive';
                    labelCell.classList.add('text-danger');
                    labelCell.classList.remove('text-success');
                }

                // Optional: You can also send an AJAX request here to update status in the backend
            });
        });
    });
</script>                    