@extends('layouts.admin')
@section('title', 'FAQ Create')
@section('content')
<div class="dashboard-content bg-light p-4 mt-5">
    <div class="content-card rounded-2 bg-white p-4 mt-lg-4 mt-md-4 mt-1">
        
        <div class="row mt-lg-4 mt-md-0 mt-0">
            <div class="col-md-12">
            
                <form id="faqForm" method="POST" class="add-user-form p-4">
                    @csrf
                  
                    <div class="row mt-lg-4 mt-md-0 mt-0">
                        <div class="col-md-6">
                            <label for="category" class="form-label">Category</label>
                            <select name="category_id" class="form-control rounded-2 form-select" id="category_id">
                                <option value="">Select Category</option>
                                @foreach($categories as $category)
                                    <option value="{{ $category->id }}">{{ $category->name }}</option>
                                @endforeach
                            </select>
                            <small id="category_id_error" style="color:red;"></small>
                        </div>
                        <div class="col-md-6 mt-lg-0 mt-md-0 mt-4">
                            <label for="status" class="form-label">Status</label>
                            <select class="form-control rounded-2 form-select" name="status" id="status">
                                <option value="">Select</option>
                                <option value="1">Active</option>
                                <option value="0">inactive</option>
                            </select>
                            <small id="status_error" style="color:red;"></small>
                        </div>
                    </div>

                    <div class="row mt-lg-4 mt-md-4 mt-4">

                        <div class="col-md-6">
                            <label for="question" class="form-label">Question</label>
                            <textarea  class="rounded-2 p-3" placeholder="Question" name="question" id="question" rows="5"></textarea>
                            <small id="question_error" style="color:red;"></small>
                        </div>

                        <div class="col-md-6 mt-lg-0 mt-md-0 mt-4">
                            <label for="answer" class="form-label">Answer</label>
                            <textarea  class="rounded-2 p-3" placeholder="Answer" name="answer" id="answer" rows="5"></textarea>
                            <small id="answer_error" style="color:red;"></small>
                        </div>
                    </div>
                   
                    <div class="row mt-5">
                        <div class="col-md-6">
                            
                            <button type="submit" class="btn add-btn px-4 py-3 w-100 rounded-pill">Save</button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>
</div>

<script>
$('#faqForm').on('submit', function(e) {
    e.preventDefault();

    $('#submitBtn').attr('disabled', true);
    $('small').text('');
    $('#successMessage').text('');

    $.ajax({
        url: "{{ route('admin.faqs.store') }}",
        method: 'POST',
        data: $(this).serialize(),
        success: function(response) {
            $('#submitBtn').attr('disabled', false);
            // $('#successMessage').text(response.message);
            showAlert(response.message,'s');
            $('#faqForm')[0].reset();
        },
        error: function(xhr) {
            $('#submitBtn').attr('disabled', false);
            
            if(xhr.status == 422) {
                let errors = xhr.responseJSON.errors;
                $.each(errors, function(key, value) {
                    $('#' + key + '_error').text(value[0]);
                });
            }
        }
    });
});
</script>

@endsection