@extends('layouts.admin')
@section('title', 'FAQ Edit')
@section('content')
<div class="dashboard-content bg-light p-4 mt-5">
    <div class="content-card rounded-2 bg-white p-4 mt-lg-4 mt-md-4 mt-1">
        
        <div class="row mt-lg-4 mt-md-0 mt-0">
            <div class="col-md-12">
            
                <form id="faqForm" action="{{ route('admin.faqs.update') }}" method="POST" class="add-user-form p-4" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                     <input type="hidden" name="id" value="{{ base64_encode($faq->id) }}">
                    <div class="row mt-lg-4 mt-md-0 mt-0">
                        <div class="col-md-6">
                            <label for="category" class="form-label">Category</label>
                            <select name="category_id" class="form-control rounded-2 form-select" id="category_id">
                                <option value="">Select Category</option>
                                @foreach($categories as $category)
                                    <option value="{{ $category->id }}" {{ $faq->category_id == $category->id ? 'selected' : '' }}>{{ $category->name }}</option>
                                @endforeach
                            </select>
                            <p class="text-danger" id="error-category_id"></p>
                        </div>
                        <div class="col-md-6 mt-lg-0 mt-md-0 mt-4">
                            <label for="status" class="form-label">Status</label>
                            <select class="form-control rounded-2 form-select" name="status" id="status">
                                <option value="1" {{ $faq->status == 1 ? 'selected' : '' }}>Active</option>
                                <option value="0" {{ $faq->status == 0 ? 'selected' : '' }}>Inactive</option>
                            </select>
                             <p class="text-danger" id="error-status"></p>
                        </div>
                    </div>

                    <div class="row mt-4">

                        <div class="col-md-6">
                            <label for="question" class="form-label">Question</label>
                            <textarea  class="rounded-2 p-3" placeholder="Question" name="question" id="question" rows="5">{{ $faq->question }}</textarea>
                             <p class="text-danger" id="error-question"></p>
                        </div>

                        <div class="col-md-6 mt-lg-0 mt-md-0 mt-4">
                            <label for="answer" class="form-label">Answer</label>
                            <textarea  class="rounded-2 p-3" placeholder="Answer" name="answer" id="answer" rows="5">{{ $faq->answer }}</textarea>
                            <p class="text-danger" id="error-answer"></p>
                        </div>
                    </div>
                   
                    <div class="row mt-5">
                        <div class="col-md-6">
                            
                            <button type="submit" class="btn add-btn px-4 py-3 w-100 rounded-pill">Save</button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>
</div>

{{-- <script>
$('#faqForm').on('submit', function(e) {
    e.preventDefault();

    $('#submitBtn').attr('disabled', true);
    $('small').text('');
    $('#successMessage').text('');

    $.ajax({
        url: '{{ route('admin.faqs.update',$faq->id) }}',
        method: 'POST',
        data: $(this).serialize(),
        success: function(response) {
            $('#submitBtn').attr('disabled', false);
            showAlert(response.message,'s');
        },
        error: function(xhr) {
            $('#submitBtn').attr('disabled', false);
            
            if(xhr.status == 422) {
                let errors = xhr.responseJSON.errors;
                $.each(errors, function(key, value) {
                    $('#' + key + '_error').text(value[0]);
                });
            }
        }
    });
});
</script> --}}

<script>

      $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
     $(document).on('submit', 'form#faqForm', function(e) {
            e.preventDefault();

            var form = $(this);
            var formData = new FormData(this);

            $.ajax({
                url: form.attr('action'),
                method: form.attr('method'),
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    if (response.success) {
                        toastr.success(response.message || "Updated Successfully");

                        window.setTimeout(function() {
                            window.location.href = "{{ route('admin.faqs.index') }}";
                        }, 2000);
                    } else if (response.errors) {

                        $.each(response.errors, function(key, error) {
                            var errorId = `#error-${key.replace('.', '_')}`;
                            $(errorId).html(error[0]);
                        });
                    } else {
                        alert("No changes were made.");
                    }
                },
                error: function(xhr) {
                    alert("An error occurred. Please try again.");
                    console.log(xhr.responseText);
                }
            });
        });
</script>

@endsection