@extends('layouts.admin')
@section('title', 'FAQ Management')
@section('content')

<div class="dashboard-content bg-light p-4 mt-5">
    <div class="content-card rounded-2 bg-white p-4 mt-lg-4 mt-md-4 mt-1">
        <div class="row align-items-center">

            <div class="col-md-12">
                <div class="d-flex gap-3 justify-content-between">
                
                    <div class="add-div-btn">
                        <a href="{{ route('admin.faqs.create') }}" class="btn add-btn px-4 py-2">Add FAQ</a>
                    </div>
                
                    <div class="add-div-btn">
                        <form>
                            <div class="input-group">
                                <span class="input-group-text bg-white">
                                    <a href="#" class="text-dark">
                                        <i class="fa-solid fa-magnifying-glass"></i>
                                    </a>
                                </span>
                                <input type="text" id="searchFaq" class="form-control border-start-0" placeholder="Search FAQ">
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            {{-- <div class="col-md-6">
                <div class="d-flex gap-3">
               
                    <div>
                        <form>
                            <div class="input-group">
                                <span class="input-group-text bg-white">
                                    <a href="#" class="text-dark">
                                        <i class="fa-solid fa-magnifying-glass"></i>
                                    </a>
                                </span>
                                <input type="text" class="form-control border-start-0" placeholder="Search User">
                            </div>
                        </form>
                    </div>
                </div>
            </div> 
            <div class="col-md-6 ">
                <div class="d-flex justify-content-between">
                    <form class="row align-items-center w-100">
                        <div class="col-md-5">
                            <div class="input-group">
                                <input type="text" class="form-control border-end-0" placeholder="Sort">
                                <span class="input-group-text bg-white">
                                    <a href="#" class="text-dark"><i class="fa-solid fa-arrow-up"></i></a>
                                    <a href="#" class="text-dark"><i class="fa-solid fa-arrow-down"></i></a>
                                </span>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <select class="form-control form-select" name="" id="">
                                <option value="filter">Filter</option>
                                <option value="value1">Value 1</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <a href="#" class="text-dark">
                                <i class="fa-solid fa-arrows-spin"></i>
                            </a>
                        </div>
                    </form>
                </div>
            </div> --}}
        </div>  
        <div class="row mt-4">
            <div class="col-md-12">
                <div id="faq-list" class="table-responsive user-table student-table position-relative" >
                    @include('admin.faq.ajax')
                    <!-- Loading Spinner -->
                    <div id="loading" class="position-absolute top-50 start-50" style="display:none;">
                        <div class="loader"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>  
</div>




<script>
    $(document).on('change', '.change-status', function () {
        const checkbox = $(this);
        const id = checkbox.data('id');
        const name = checkbox.data('name');
        const isChecked = checkbox.is(':checked');
        const type = isChecked ? btoa('enable') : btoa('disable');
        const action = isChecked ? 'activate' : 'deactivate';

        Swal.fire({
            icon: 'warning',
            title: `Are you sure you want to ${action} "${name}"?`,
            showCancelButton: true,
            confirmButtonColor: '#007358',
            confirmButtonText: 'YES',
            cancelButtonText: 'CANCEL'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    type: 'POST',
                    url: "{{ route('admin.faq.status') }}",
                    data: {
                        "_token": "{{ csrf_token() }}",
                        'id': id,
                        'type': type
                    },
                    success: function (response) {
                        if (response.success) {
                            $(`#statusLabel${atob(id)}`).text(isChecked ? 'Active' : 'Inactive');
                            showAlert("Status Changed Successfully","s");
                        } else {
                            toastr.error("Failed to change status");
                            checkbox.prop('checked', !isChecked); // Revert switch
                        }
                    },
                    error: function (xhr, textStatus, errorThrown) {
                        showAlert("An error occurred: " + errorThrown,"e");
                        checkbox.prop('checked', !isChecked); // Revert switch
                    }
                });
            } else {
                checkbox.prop('checked', !isChecked); // Revert if cancelled
            }
        });
    });
</script>



<script>
    $(document).on('click', '.delete-btn', function () {
        var itemId = $(this).data('id');

        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: "{{ route('admin.faqs.destroy') }}",
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        id: itemId
                    },
                    success: function (response) {
                        Swal.fire(
                            'Deleted!',
                            'FAQ has been deleted.',
                            'success'
                        ).then(() => {
                            location.reload();
                        });
                    },
                    error: function (xhr) {
                        Swal.fire(
                            'Error!',
                            'Something went wrong.',
                            'error'
                        );
                    }
                });
            }
        });
    });
</script>


<script>
    $(document).ready(function() {

        function fetchFaqs(url){
            let search = $('#searchFaq').val();

            $.ajax({
                url: url,
                type: "GET",
                data: { search: search },
                beforeSend: function() {
                    $('#loading').show();
                },
                success: function(data){
                    $('#faq-list').html(data);
                    $('#loading').hide();
                },
                error: function() {
                    alert('Error loading data.');
                    $('#loading').hide();
                }
            });
        }

        // Handle Pagination Click
        $(document).on('click', '.pagination-wrapper a', function(e) {
            e.preventDefault();
            let url = $(this).attr('href');
            fetchFaqs(url);
        });

        // Handle Search Input Typing (with delay)
        let typingTimer;
        let doneTypingInterval = 500; // 0.5 second after user stops typing

        $('#searchFaq').on('keyup', function () {
            clearTimeout(typingTimer);
            typingTimer = setTimeout(function() {
                fetchFaqs("{{ route('admin.faqs.index') }}");
            }, doneTypingInterval);
        });

        $('#searchFaq').on('keydown', function () {
            clearTimeout(typingTimer);
        });

    });
</script>

@endsection
