<style>
    .status-active {
    color: green;
    font-weight: bold;
}

.status-inactive {
    color: red;
    font-weight: bold;
}
</style>
@php
    $authCheck = auth()->check();
    $permission= auth()->user();
 @endphp
<table class="table table-striped">
                        <thead class="border-bottom">
                            <tr>
                                <th>S.No.</th>
                                <th>Name</th>
                                <th>Status</th> 
                                <th>Actions</th> 
                            </tr>
                        </thead>
                       
                        <tbody>
                            @foreach($feedbackoption as $key => $feedbackop)
                            <tr>
                                <td>{{ $key + 1 }}</td>
                                
                                <td>{{ $feedbackop->name }}</td>
                                <!-- <td>{{ $feedbackop->status == 1 ? 'Active' : 'Inactive' }}</td> -->
                                 <td class="ms-2" id="statusLabel{{ $feedbackop->id }}">
                                    {{ $feedbackop->status == 1 ? 'Active' : 'Inactive' }}
                                 </td>
                                
                                <td class="d-flex align-items-center">
                                    
                                    <div class="lights">
                                        <div class="form-check form-switch mb-0 h-100">
                                            <input 
                                                class="form-check-input mt-0 change-status"
                                                data-bs-toggle="tooltip" data-bs-placement="top" title="Status" 
                                                type="checkbox" 
                                                id="statusSwitch{{ $feedbackop->id }}" 
                                                name="statusSwitch" 
                                                value="1"
                                                data-id="{{ base64_encode($feedbackop->id) }}"
                                                data-name="{{ $feedbackop->title }}"
                                                {{ $feedbackop->status == 1 ? 'checked' : '' }}
                                            >
                                            
                                           
                                        </div>
                                    </div>
                                     @if($authCheck && $permission->hasPermission('feedbackoption-edit'))
                                    <a href="{{ route('admin.feedbackoption.edit', base64_encode($feedbackop->id)) }}" class="text-success me-2" data-bs-toggle="tooltip" data-bs-placement="top" title="Edit">
                                        <i class="fa-solid fa-pen-to-square"></i>
                                    </a> 
                                    @endif
                                    @if($authCheck && $permission->hasPermission('feedbackoption-delete'))
                                        <a href="javascript:void(0);" 
                                            class="text-danger me-2 delete-btn" 
                                            data-bs-toggle="tooltip" data-bs-placement="top" title="Delete"
                                            data-id="{{ base64_encode($feedbackop->id) }}">
                                                <i class="fa-solid fa-trash"></i>
                                        </a>
                                    @endif
                                </td>

                              
                            </tr>


                            @endforeach
                          
                        </tbody>
                    </table>
                    
        <form method="GET" id="perPageForm">
                <div class="d-flex align-items-center mb-3">
                    <label for="per_page" class="me-2">Show:</label>
                    <select name="per_page" id="per_page" class="form-select w-auto">
                        <option value="10" {{ request('per_page') == 10 ? 'selected' : '' }}>10</option>
                        <option value="all" {{ request('per_page') == 'all' ? 'selected' : '' }}>All</option>
                    </select>
                </div>
        </form>

<script>
    document.getElementById('per_page').addEventListener('change', function () {
        document.getElementById('perPageForm').submit();
    });
</script>

<script>
document.addEventListener("DOMContentLoaded", function () {
    const statusCells = document.querySelectorAll('[id^="statusLabel"]');
    // Initial color setting
    statusCells.forEach(function(cell) {
        const status = cell.textContent.trim().toLowerCase();

        if (status === 'active') {
            cell.classList.add('text-success');
            cell.classList.remove('text-danger');
        } else if (status === 'inactive') {
            cell.classList.add('text-danger');
            cell.classList.remove('text-success');
        }
    });

    // Handle status toggle without page refresh
    const switches = document.querySelectorAll('.change-status');

    switches.forEach(function (toggle) {
        toggle.addEventListener('change', function () {
            const studentId = this.getAttribute('data-id');
            const labelCell = document.getElementById('statusLabel' + atob(studentId)); 

            if (this.checked) {
                labelCell.textContent = 'Active';
                labelCell.classList.add('text-success');
                labelCell.classList.remove('text-danger');
            } else {
                labelCell.textContent = 'Inactive';
                labelCell.classList.add('text-danger');
                labelCell.classList.remove('text-success');
            }

            
        });
    });
});
</script>                 