@extends('layouts.admin')
@section('title', 'Feedback Option')
<!-- jQuery (required for Toastr) -->
{{-- <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script> --}}
@section('content')
<div class="dashboard-content bg-light p-4 mt-5">
    <div class="content-card rounded-2 bg-white p-4 mt-lg-4 mt-md-4 mt-1">
        
        <div class="row mt-4">
            <div class="col-md-12">
                <form id="faqForm" action="{{ route('admin.feedbackoption.store') }}" method="POST" class="add-user-form p-4">
                @csrf
                    <div class="row">
                        <div class="col-md-6">
                            <label for="#" class="form-label">Name<span class="text-danger">*</span></label>
                            <input type="text" class="form-control rounded-2" id="f-name" placeholder="Enter Name" name="name">    
                            <p class="text-danger" id="error-name"></p>
                        </div>
                        <div class="col-md-6">
                            <label for="status" class="form-label">Status</label>
                            <select class="form-control rounded-2 form-select" name="status" id="status">
                                <option value="">None</option>
                                <option value="1">Active</option>
                                <option value="0">inactive</option>
                            </select>
                            <p class="text-danger" id="error-status"></p>
                        </div>
                    </div>
                    {{--                   
                    <div class="row mt-4">
                        
                    </div> --}}
                   
                    <div class="row mt-5">
                        <div class="col-md-6">
                            <button type="submit" class="btn add-btn px-4 py-3 w-100 rounded-pill">Save</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>


<!-- Toastr JS -->
{{-- <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script> --}}

<script>
    $(document).on('submit', 'form#faqForm', function(event) {
                        
        event.preventDefault();
        //clearing the error msg
        $('p.error_container').html("");

        var form = $(this);
        var formid = $(this).attr('id');

        var data = new FormData($(this)[0]);
        var url = form.attr("action");
        var loadingText = '<i class="fa fa-circle-o-notch fa-spin"></i> loading...';
        $('.submit').attr('disabled', true);
        $('.form-control').attr('readonly', true);
        $('.form-control').addClass('disabled-link');
        $('.error-control').addClass('disabled-link');
        if ($('.submit').html() !== loadingText) {
            $('.submit').html(loadingText);
        }
        $.ajax({
            type: form.attr('method'),
            url: url,
            data: data,
            cache: false,
            contentType: false,
            processData: false,
            success: function(response) {
                window.setTimeout(function() {
                    $('.submit').attr('disabled', false);
                    $('.form-control').attr('readonly', false);
                    $('.form-control').removeClass('disabled-link');
                    $('.error-control').removeClass('disabled-link');
                    $('.submit').html('Submit');
                }, 2000);
                //console.log(response);
                if (response.success == true) {

                    //notify
                    toastr.success("Created Successfully");

                    // redirect to google after 5 seconds
                    window.setTimeout(function() {
                        window.location = "{{ route('admin.feedback-option') }}";
                    }, 2000);
                }
                //show the form validates error
                if (response.success == false) {
                    for (control in response.errors) {
                        var error_text = control.replace('.', "_");
                        $('#'+formid+' #error-' + error_text).html(response.errors[control]);
                        // $('#error-'+error_text).html(response.errors[error_text][0]);
                        // console.log('#error-'+error_text);
                    }
                    // console.log(response.errors);
                }
            },
            error: function(response) {
                // alert("Error: " + errorThrown);
                console.log(response);
            }
        });
        event.stopImmediatePropagation();
        return false;
    });
</script>

@endsection