@extends('layouts.admin')
@section('title', 'Create Permission')
@section('content')
<div class="dashboard-content bg-light p-4 mt-5">
    <div class="content-card rounded-2 bg-white p-4 mt-lg-4 mt-md-4 mt-1">
        <div class="row mt-lg-4 mt-md-0 mt-0">
            <div class="col-md-12">
                @if(session('success'))
                    <div class="alert alert-success mt-3">{{ session('success') }}</div>
                @endif
                <form action="{{ route('admin.permissions.store') }}" method="POST" class="add-user-form p-4">
                    @csrf
                    <div class="row">
                        <div class="col-md-6">
                            <label for="#" class="form-label">Permission Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control rounded-2" placeholder="Enter admin name" value="{{old('name')}}" name="name" required>    
                            @if($errors->has('name'))
                                <div class="error text-danger">{{ $errors->first('name') }}</div>
                            @endif
                        </div>
                    </div>

                    <div class="row mt-5">
                        <div class="col-md-6">
                            <button type="submit" class="btn add-btn px-4 py-3 w-100 rounded-pill">Save Permission</button>
                            {{-- <a href="{{ route('admin.permissions.index') }}" class="btn btn-secondary">Cancel</a> --}}
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@endsection