@extends('layouts.admin')
@section('title', 'Role Management')
@section('content')

<div class="dashboard-content bg-light p-4 mt-5">
    <div class="content-card rounded-2 bg-white p-4 mt-lg-4 mt-md-4 mt-1">
        <div class="row align-items-center">

            <div class="col-md-12">
                <div class="d-flex gap-3 justify-content-between">
                    <div class="add-div-btn">
			        <a href="{{ route('admin.permissions.create') }}" class="btn add-btn px-4 py-2">Add Permission</a>
		            </div>
                    <div class="add-div-btn">
                        <form>
                            <div class="input-group">
                                <span class="input-group-text bg-white"><a href="#" class="text-dark"><i class="fa-solid fa-magnifying-glass"></i></a></span>
                                <input type="text" class="form-control border-start-0" placeholder="Search User">
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            {{-- <div class="col-md-6">
                <div class="d-flex gap-3">
                    <!-- <a href="add-user.html" class="btn add-btn px-4 py-2">Add Users</a> -->
                    <div>
                        <form>
                            <div class="input-group">
                                <span class="input-group-text bg-white"><a href="#" class="text-dark"><i class="fa-solid fa-magnifying-glass"></i></a></span>
                                <input type="text" class="form-control border-start-0" placeholder="Search User">
                            </div>
                        </form>
                    </div>
                </div>
            </div> --}}
            {{-- <div class="col-md-6 mt-lg-0 mt-md-0 mt-4">
                <div class="d-flex justify-content-between">
                    <form class="row align-items-center w-100">
                        <div class="col-lg-6 col-md-6 col-6">
                            <div class="input-group">
                                <input type="text" class="form-control border-end-0" placeholder="Sort">
                                <span class="input-group-text bg-white"><a href="#" class="text-dark"><i class="fa-solid fa-arrow-up"></i></a><a href="#" class="text-dark"><i class="fa-solid fa-arrow-down"></i></a></span>
                            </div>
                        </div>
                        <div class="col-lg-5 col-md-5 col-5">
                            <select class="form-control form-select" name="" id="">
                                <option value="filter">Filter</option>
                                <option value="value1">Value 1</option>
                            </select>
                        </div>
                        <div class="col-lg-1 col-md-1 col-1">
                            <a href="#" class="text-dark"><i class="fa-solid fa-arrows-spin"></i></a>
                        </div>
                    </form>
                </div>
            </div> --}}
        </div>  
        <div class="row mt-4">
            <div class="col-md-12">
                <div class="table-responsive user-table student-table">
                    <table class="table table-striped">
                        <thead class="border-bottom">
                            <tr>
                                <th>S.No.</th>
                                <th>Permission Name</th>
                                <th>Actions</th>
                                {{-- <th>Actions</th> --}}
                            </tr>
                        </thead>
                        <tbody>
                        @foreach($permissions as $key => $permission)
                            <tr>
                                <td>{{ $key + 1 }}</td>
                                <td>{{ $permission->name }}</td>
                                
                                <td class="d-flex align-items-center">
                                    <!-- <div class="lights">
                                        <div class="form-check form-switch mb-0 h-100">
                                            <input class="form-check-input mt-0" type="checkbox" id="mySwitch" name="darkmode" value="yes">
                                        </div>
                                    </div> -->
                                    <a href="" class="text-success me-2" data-bs-toggle="tooltip" data-bs-placement="top" title="Edit"><i class="fa-solid fa-pen-to-square"></i></a>
                                   
                                    <a href="{{ route('admin.permissions.edit', $permission->id) }}" class="text-danger me-2" data-bs-toggle="modal" data-bs-target="#myModal1" data-bs-toggle="tooltip" data-bs-placement="top" title="Delete"><i class="fa-solid fa-trash"></i></a>
                                    {{-- <form action="{{ route('admin.roles.destroy', $role->id) }}" method="POST" class="d-inline"> --}}
                                        {{-- @csrf
                                        @method('DELETE') --}}
                                    {{-- </form> --}}
                                      <a href="view-student-details.html" class="text-info"></a>
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
               
            </div>
        </div>
    </div>  
</div>

@endsection