
<table class="table table-striped">
                        <thead class="border-bottom">
                            <tr>
                                <th>S.No.</th>
                                <th>User Name</th>
                                <th>Email</th>
                                <th>Sub ID</th>
                                <th>Plan Type</th>
                                <th>Amount</th> 
                                <th>Start Date</th> 
                                <th>End Date</th> 
                                <th>Interval</th> 
                                <th>Sub. Status</th>
                                <th>Payment Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($list as $key => $sub)
                                <tr>
                                    <td>{{ ++$key }}</td>
                                    <td>
                                        @if($sub->user!=null)
                                            {{-- <img src="{{ asset('storage/avatars/'.$sub->user->avatar) }}" alt=""> --}}
                                            {{ $sub->user->name }}
                                        @else
                                            N/A
                                        @endif
                                    </td>
                                    <td>
                                        @if($sub->user!=null)
                                            {{ $sub->user->email }}
                                        @else
                                            N/A
                                        @endif
                                    </td>
                                    <td>
                                        {!! $sub->stripe_subscription_id != 'Free Trial' ? '<a href="https://dashboard.stripe.com/test/subscriptions/'.$sub->stripe_subscription_id.'">'.$sub->stripe_subscription_id.'</a>' : $sub->stripe_subscription_id !!}
                                    </td>
                                    <td>
                                        @if($sub->is_trial==1)
                                            Free Trial
                                        @else
                                            @if($sub->plan!=null)
                                                {{ $sub->plan->name }}
                                            @else
                                                N/A
                                            @endif
                                        @endif
                                    </td>
                                    <td>${{ $sub->amount }}</td>
                                    <td>
                                        {{ date('Y/m/d',strtotime($sub->start_at)).' at '.date('h:i:s a',strtotime($sub->start_at)) }}
                                    </td>
                                    <td>
                                        {{ date('Y/m/d',strtotime($sub->end_at)) }}
                                    </td>
                                    <td>
                                        @if($sub->is_trial==1)
                                            7 Days
                                        @else
                                            @if($sub->plan!=null)
                                                {{ ucfirst($sub->plan->interval) }}
                                            @else
                                                N/A
                                            @endif
                                        @endif
                                    </td>
                                    <td>
                                        {{ ucfirst($sub->status) }}
                                    </td>
                                    <td>
                                        @if($sub->is_trial==1)
                                            <span class="text-success">--</span>
                                        @else
                                            @if($sub->payment_status==1)
                                                <span class="text-success">Success</span>
                                            @else
                                                <span class="text-danger">Failed</span>
                                            @endif
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>

                    <!-- Pagination Links -->
                    <div class="pagination-wrapper mb-4">
                        {{ $list->links() }}
                    </div>
