@extends('layouts.admin')
@section('title', 'Create Role')
@section('content')
<div class="dashboard-content bg-light p-4 mt-5">
    <div class="content-card rounded-2 bg-white p-4 mt-lg-4 mt-md-4 mt-1">
        <div class="row mt-lg-4 mt-md-0 mt-0">
        <div class="row align-items-center">
            <div class="col-md-12">
                <p><a href="{{ route('admin.roles.index') }}" class="text-dark text-decoration-none position-relative"><i class="fa-solid fa-chevron-left me-2"></i> Add Role</a></p>
            </div>
        </div>
            <div class="col-md-12"> 
                <!-- @if(session('success'))
                    <div class="alert alert-success mt-3">{{ session('success') }}</div>
                        <script>
                            // Redirect after 3 seconds (3000 milliseconds)
                            setTimeout(function() {
                               window.location.href = "{{ route('admin.roles.index') }}";
                            }, 2000);
                        </script>
                @endif -->
                <form id="roleform" action="{{ route('admin.roles.store') }}" method="POST" class="add-user-form p-4" enctype="multipart/form-data">
                    @csrf
                    <div class="row">
                        <div class="col-md-6">
                            <label for="#" class="form-label">Role Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control rounded-2" placeholder="Enter admin name" value="{{old('name')}}" name="name">    
                             <p class="text-danger error_container" id="error-name"></p>
                            <!-- @if($errors->has('name'))
                                <div class="error text-danger">{{ $errors->first('name') }}</div>
                            @endif -->
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-md-6">
                            <label for="description" class="form-label">Description</label>
                            <textarea class="rounded-2 d-block p-2" name="description" rows="5" placeholder="Description">{{ old('description') }}</textarea>
                             <!-- <p class="text-danger error_container" id="error-description"></p> -->
                            <!-- @if($errors->has('description'))
                                <div class="error text-danger">{{ $errors->first('description') }}</div>
                            @endif -->
                        </div>
                    </div>

                    <div class="row mt-5">
                        <div class="col-md-6">
                            <button type="submit" class="btn add-btn px-4 py-3 w-100 rounded-pill">Save</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
      $(document).on('submit', 'form#roleform', function(event) {
                        
        event.preventDefault();
        $('p.error_container').html("");

        var form = $(this);
        var formid = $(this).attr('id');

        var data = new FormData($(this)[0]);
        var url = form.attr("action");
        var loadingText = '<i class="fa fa-circle-o-notch fa-spin"></i> loading...';
        $('.submit').attr('disabled', true);
        $('.form-control').attr('readonly', true);
        if ($('.submit').html() !== loadingText) {
            $('.submit').html(loadingText);
        }
        $.ajax({
            type: form.attr('method'),
            url: url,
            data: data,
            cache: false,
            contentType: false,
            processData: false,
            success: function(response) {
                // window.setTimeout(function() {
                    
                // }, 2000);
                //console.log(response);
                if (response.success == true) {
                    //notify
                    toastr.success("Created Successfully");

                    // redirect to google after 5 seconds
                    window.setTimeout(function() {
                        window.location = "{{ route('admin.roles.index') }}";
                    }, 2000);
                }
                //show the form validates error
               
                if (response.success == false) {
                    for (control in response.errors) {
                        var error_text = control.replace('.', "_");
                        $('#'+formid+' #error-' + error_text).html(response.errors[control]);
                        
                    }

                    $('.submit').attr('disabled', false);
                    $('.form-control').attr('readonly', false);
                    $('.submit').html('Save');
                    // console.log(response.errors);
                }
            },
            error: function(response) {
                alert("Error: " + errorThrown);
                console.log(response);
                $('.submit').attr('disabled', false);
                    $('.form-control').attr('readonly', false);
                    $('.submit').html('Save');
            }
        });
        event.stopImmediatePropagation();
        return false;
    });
          
</script>

<script>
    setTimeout(() => {
        const successAlert = document.querySelector('.alert-success');
        if (successAlert) {
            successAlert.remove();
        }
    }, 3000);
</script>
@endsection