@extends('layouts.admin')

@section('content')
<div class="col-md-9">
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h4 class="mb-0">Edit Role: {{ $role->name }}</h4>
        </div>
        <div class="card-body">
            <!-- Update Role Form -->
            <form action="{{ route('admin.roles.update', $role->id) }}" method="POST" class="mb-4">
                @csrf
                @method('PUT')
                <div class="mb-3">
                    <label class="form-label">Role Name</label>
                    <input type="text" name="name" class="form-control" value="{{ $role->name }}" required>
                </div>
                <button type="submit" class="btn btn-success"><i class="fas fa-save"></i> Update Role</button>
                <a href="{{ route('admin.roles.index') }}" class="btn btn-secondary">Cancel</a>
            </form>
        </div>
        <div class="card-body">
            <!-- Assign Permissions -->
            <h5 class="mb-3">Assign Permissions</h5>
            <form action="{{ route('admin.roles.updatePermissions', $role->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="row">
                    @foreach($permissions as $permission)
                        <div class="col-md-4">
                            <div class="form-check">
                                <input type="checkbox" class="form-check-input" id="permission_{{$permission->id}}" name="permissions[]" 
                                    value="{{ $permission->id }}" 
                                    {{ $role->hasPermissionTo($permission->name) ? 'checked' : '' }}>
                                <label class="form-check-label" for="permission_{{$permission->id}}">{{ $permission->name }}</label>
                            </div>
                        </div>
                    @endforeach
                </div>
                <button type="submit" class="btn btn-primary mt-3"><i class="fas fa-check"></i> Update Permissions</button>
            </form>
        </div>
    </div>
</div>
@endsection
