@extends('layouts.admin')
@section('title', 'Create Permission')
@section('content')
<div class="dashboard-content bg-light p-4 mt-5">
    <div class="content-card rounded-2 bg-white mt-lg-4 mt-md-1 mt-1">
        <!-- Nav pills -->
        <ul class="nav nav-pills profile-tabs pt-4">
            <li class="nav-item w-50">
                <a class="nav-link text-decoration-none active" data-bs-toggle="pill" href="#profile">Profile Settings</a>
            </li>
            <li class="nav-item w-50">
                 <a class="nav-link text-decoration-none" data-bs-toggle="pill" href="#change">Change Password</a>
            </li>
        </ul>
        <!-- Tab panes -->
        <div class="tab-content mt-5 p-4">
            <div class="tab-pane container active" id="profile">
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <p class="mb-0">
                            <a href="#" class="text-dark text-decoration-none position-relative d-flex align-items-baseline back-link"><i class="fa-solid fa-chevron-left me-2"></i> Profile Setting</a>
                        </p>
                        <p class="back-text">Update your personal details and customize your experience.</p>
                    </div>
                </div>  
                <div class="row mt-5">
                    <div class="col-md-12">
                        <form action="#" class="add-user-form profile-form p-4">
                            <div class="row">
                                <div class="col-md-2">
                                    <div class="profile-icons"><a href="#" class="text-decoration-none"><img src="img/profile-icons1.png" alt=""> <span class="camera-icons rounded-circle d-flex justify-content-center align-items-center"><i class="fa-solid fa-camera"></i></span></a></div>
                                </div>
                                <div class="col-md-6 ps-5">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <label for="#" class="form-label">Full Name<span class="text-danger">*</span></label>
                                            <input type="text" class="form-control rounded-pill" id="f-name" placeholder="e.g Dianne Russell" name="f-name">    
                                        </div>
                                        <div class="col-md-12 mt-4">
                                            <label for="email" class="form-label">Email address<span class="text-danger">*</span></label>
                                            <input type="email" class="form-control rounded-pill" id="email" placeholder="e.g russelldianne@gmail.com" name="email">
                                        </div>
                                        <div class="col-md-12 mt-4">
                                            <label for="#" class="form-label">Mobile Number</label>
                                            <input type="tel" class="form-control rounded-pill" id="m-number" placeholder="e.g. 8976543245" name="m-number">    
                                        </div>
                                        <div class="col-md-12 mt-5">
                                            <button class="btn add-btn px-4 py-3 w-100 rounded-pill">Save</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="tab-pane container fade" id="change">
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <p class="mb-0">
                            <a href="#" class="text-dark text-decoration-none position-relative d-flex align-items-baseline back-link"><i class="fa-solid fa-chevron-left me-2"></i> Change Password</a>
                        </p>
                        <p class="back-text">Use strong password to make your account secure.</p>
                    </div>
                </div>  
                <div class="row mt-5">
                    <div class="col-md-12">
                        <form action="#" class="add-user-form profile-form p-4">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="profile-icons"><img src="img/change-psw-img1.png" alt=""></div>
                                </div>
                                <div class="col-md-6 ps-5">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <label for="o-psw" class="form-label">Old Password<span class="text-danger">*</span></label>
                                            <input type="password" class="form-control rounded-pill" id="o-psw" placeholder="*********" name="o-psw">  
                                        </div>
                                        <div class="col-md-12 mt-4">
                                            <label for="psw" class="form-label">Password<span class="text-danger">*</span></label>
                                            <input type="password" class="form-control rounded-pill" id="psw" placeholder="*********" name="psw"> 
                                        </div>
                                        <div class="col-md-12 mt-4">
                                            <label for="c-psw" class="form-label">Confirm Password<span class="text-danger">*</span></label>
                                            <input type="password" class="form-control rounded-pill" id="c-psw" placeholder="*********" name="c-psw"> 
                                        </div>
                                        <div class="col-md-12 mt-5">
                                            <button class="btn add-btn px-4 py-3 w-100 rounded-pill">Save</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection