<style>
    .status-active {
    color: green;
    font-weight: bold;
}

.status-inactive {
    color: red;
    font-weight: bold;
}
</style>
@php
    $authCheck = auth()->check();
    $permission= auth()->user();
 @endphp
<table class="table table-striped">
                        <thead class="border-bottom">
                            <tr>
                                <th>S.No.</th>
                                <th>User Name</th>
                                <th>Email</th>
                                <th>Parent’s Email</th> 
                                <th>DOB</th>
                                <th>Status</th> 
                                <th>Actions</th> 
                            </tr>
                        </thead>
                       
                        <tbody>
                            @foreach($students as $key => $student)
                            <tr>
                                <!-- <td>{{ $key + 1 }}</td> -->
                                 <td>{{ $students->firstItem() + $key }}</td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <img src="{{ file_exists(public_path('storage/avatars/' . $student->avatar)) && $student->avatar
                                            ? url('storage/avatars/' . $student->avatar)
                                            : asset('img/no-image.png') }}"
                                            alt="" class="rounded-circle me-2"
                                            style="width: 50px; height: 50px; object-fit: cover;">
                                        <span>{{ $student->name }}</span>
                                    </div>
                                </td>
                               
                                <td>{{ $student->email }}</td>
                                <td>{{ $student->parent_email }}</td>
                               <td>{{ \Carbon\Carbon::parse($student->dob)->format('Y-m-d') }}</td>
                              {{-- <td id="statusLabel{{ $student->id }}" class="ms-2 {{ $student->status == 1 ? 'text-success' : 'text-danger' }}">
                                    {{ $student->status == 1 ? 'Active' : 'Inactive' }}
                                </td> --}}
                               
                                <td class="ms-2 statusChange" id="statusLabel{{ $student->id }}">
                                    {{ $student->status == 1 ? 'Active' : 'Inactive' }}
                                </td>


                                <td class="">
                                    <div class="d-flex align-items-center">
                                        <div class="lights">
                                            <div class="form-check form-switch mb-0 h-100">
                                                <input 
                                                    class="form-check-input mt-0 change-status" 
                                                    data-bs-toggle="tooltip" data-bs-placement="top" title="Status"
                                                    type="checkbox" 
                                                    id="statusSwitch{{ $student->id }}" 
                                                    name="statusSwitch" 
                                                    value="1"
                                                    data-id="{{ base64_encode($student->id) }}"
                                                    data-name="{{ $student->title }}"
                                                    {{ $student->status == 1 ? 'checked' : '' }}
                                                >
                                            </div>
                                        </div>

                                    @if($authCheck && $permission->hasPermission('student-edit'))
                                    <a href="{{ route('admin.student.edit', base64_encode($student->id)) }}" class="text-success me-2" data-bs-toggle="tooltip" data-bs-placement="top" title="Edit">
                                        <i class="fa-solid fa-pen-to-square"></i>
                                    </a> 
                                   @endif
                                    @if($authCheck && $permission->hasPermission('student-delete'))
                                    <a href="javascript:void(0);" 
                                        class="text-danger me-2 delete-btn" 
                                        data-bs-toggle="tooltip" data-bs-placement="top" title="Delete"
                                        data-id="{{ base64_encode($student->id) }}">
                                            <i class="fa-solid fa-trash"></i>
                                    </a>
                                   @endif
                                   @if($authCheck && $permission->hasPermission('student-show'))
                                    <a href="{{ route('admin.student.view', base64_encode($student->id)) }}" class="text-info" data-bs-toggle="tooltip" data-bs-placement="top" title="View"><i class="fa-solid fa-eye"></i></a>
                                    @endif
                                    </div>
                                </td>

                              
                            </tr>


                            @endforeach
                          
                        </tbody>
                    </table>
                    <div class="pagination-wrapper mb-4">
                        {{ $students->links() }}
                    </div>


<script>
document.addEventListener("DOMContentLoaded", function () {
    const statusCells = document.querySelectorAll('[id^="statusLabel"]');

    // Initial color setting
    statusCells.forEach(function(cell) {
        const status = cell.textContent.trim().toLowerCase();

        if (status === 'active') {
            cell.classList.add('text-success');
            cell.classList.remove('text-danger');
        } else if (status === 'inactive') {
            cell.classList.add('text-danger');
            cell.classList.remove('text-success');
        }
    });

    // Handle status toggle without page refresh
    const switches = document.querySelectorAll('.change-status');

    switches.forEach(function (toggle) {
        toggle.addEventListener('change', function () {
            const studentId = this.getAttribute('data-id');
            const labelCell = document.getElementById('statusLabel' + atob(studentId)); // decode base64 id

            if (this.checked) {
                labelCell.textContent = 'Active';
                labelCell.classList.add('text-success');
                labelCell.classList.remove('text-danger');
            } else {
                labelCell.textContent = 'Inactive';
                labelCell.classList.add('text-danger');
                labelCell.classList.remove('text-success');
            }

            // Optional: You can also send an AJAX request here to update status in the backend
        });
    });
});
</script>

