@extends('layouts.admin')
@section('title', 'Edit Student')
@section('content')
 
<div class="dashboard-content bg-light p-4 mt-5">
    <div class="content-card rounded-2 bg-white p-4 mt-lg-4 mt-md-4 mt-1">
        <div class="row align-items-center">
            <div class="col-md-12">
                <p><a href="{{ route('admin.student') }}" class="text-dark text-decoration-none position-relative"><i class="fa-solid fa-chevron-left me-2"></i> Edit Student Details</a></p>
            </div>
        </div>
        <div class="row mt-lg-4 mt-md-0 mt-0">
            <div class="col-md-12">
                @if(session('success'))
                    <div class="alert alert-success mt-3">{{ session('success') }}</div>
                @endif
                <form id="Updatestudent" action="{{ route('admin.student.update') }}" method="POST" class="add-user-form p-4" enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="id" value="{{ base64_encode($student->id) }}">
                    <div class="row">
                        <div class="col-md-12">
                            {{-- <p class="profile-icons"><a href="#" class="text-decoration-none"><img src="img/edit-student.png" alt=""> <span class="camera-icons rounded-circle d-flex justify-content-center align-items-center"><i class="fa-solid fa-camera"></i></span></a></p> --}}

                            <p class="profile-icons position-relative d-inline-block">
                                <a href="#" class="text-decoration-none" onclick="event.preventDefault(); document.getElementById('imageInput').click();">
                                    <!-- Show existing image or fallback -->
                                    {{-- <i class="fa-solid fa-circle-user fa-5x"></i> --}}
                                  <img src="{{ ($student->avatar!='') ? asset('storage/avatars/' . $student->avatar) : asset('img/no-image.png') }}"
                                    onerror="this.onerror=null; this.src='{{ ($student->avatar!='') ? asset('storage/avatars/' . $student->avatar) : asset('img/no-image.png') }}';"
                                    alt="User Image"
                                    id="profilePreview"
                                    style="width: 120px; height: 120px; object-fit: cover; border-radius: 50%;">
                                    <!-- Camera icon overlay -->
                                    <span class="camera-icons rounded-circle d-flex justify-content-center align-items-center position-absolute"
                                        style="width: 40px; height: 40px; bottom: 0; right: 0;">
                                        <i class="fa-solid fa-camera"></i>
                                    </span>
                                </a>

                                <!-- Hidden file input -->
                                <input type="file" name="image" id="imageInput" class="d-none" accept="image/*" onchange="previewProfileImage(this);">
                            </p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <label for="#" class="form-label">Full Name<span class="text-danger">*</span></label>
                            <input type="text" class="form-control rounded-2" id="f-name" value="{{ $student->name }}"name="name" required>    
                            <!-- @if($errors->has('name'))
                                <div class="error text-danger">{{ $errors->first('name') }}</div>
                            @endif -->
                            <p class="text-danger" id="error-name"></p>
                        </div>

                        <div class="col-md-6 mt-lg-0 mt-md-0 mt-4">
                            <label for="email" class="form-label">Email address<span class="text-danger">*</span></label>
                            <input type="email" class="form-control rounded-2" id="email" value="{{ $student->email }}" name="email">
                            <!-- @if($errors->has('email'))
                                <div class="error text-danger">{{ $errors->first('email') }}</div>
                            @endif -->
                            <p class="text-danger" id="error-email"></p>
                        </div>
                    </div>
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <label for="dob" class="form-label">Date of Birth<span class="text-danger">*</span></label>
                            <input 
                                type="date" 
                                class="form-control rounded-2" 
                                id="dob" 
                                name="dob" 
                                value="{{ \Carbon\Carbon::parse($student->dob)->format('Y-m-d') }}">
                            
                            <!-- @if($errors->has('dob'))
                                <div class="error text-danger">{{ $errors->first('dob') }}</div>
                            @endif -->
                            <p class="text-danger" id="error-dob"></p>
                        </div>
                       
                        <div class="col-md-6">
                            <label for="p-email" class="form-label">Parent’s Email ID<span class="text-danger">*</span></label>
                            <input type="email" class="form-control rounded-2" value="{{ $student->parent_email }}" id="p-email" placeholder="Enter parent email" name="p_email">
                             <p class="text-danger" id="error-p_email"></p>
                        </div>
                    </div>
                    
                   <div class="row mt-4">
                        <div class="col-md-6">
                            <label for="status" class="form-label">Status</label>
                            <select class="form-control rounded-2 form-select" name="status" id="status">
                                <option value="1" {{ $student->status == '1' ? 'selected' : '' }}>Active</option>
                                <option value="0" {{ $student->status == '0' ? 'selected' : '' }}>Blocked</option>
                            </select>
                        </div>
                       
                         <div class="col-md-6">
                            <label for="report" class="form-label">Report Frequency</label>
                            <select class="form-control rounded-2 form-select" name="frequency" id="report">
                                <option value="weekly" {{ $student->status == 'weekly' ? 'selected' : '' }}>Weekly</option>
                                <option value="monthly" {{ $student->status == 'monthly' ? 'selected' : '' }}>Monthly</option>
                            </select>
                        </div>
                       
                    </div>
                 
                    <div class="row mt-5">
                        <div class="col-md-6">
                        <button type="submit" class="btn add-btn px-4 py-3 w-100 rounded-pill">Save</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).on('submit', 'form#Updatestudent', function(e) {
        e.preventDefault();

        var form = $(this);
        var formData = new FormData(this);

        $.ajax({
            url: form.attr('action'),
            method: form.attr('method'),
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
               
                if (response.success) {
                    toastr.success(response.message || "Updated Successfully");

                    window.setTimeout(function() {
                        window.location.href = "{{ route('admin.student') }}";
                    }, 2000);
                } else if (response.errors) {

                    $.each(response.errors, function(key, error) {
                        var errorId = `#error-${key.replace('.', '_')}`;
                        $(errorId).html(error[0]);
                    });
                } else {
                    alert("No changes were made.");
                }
            },
            error: function(xhr) {
                alert("An error occurred. Please try again.");
                console.log(xhr.responseText);
            }
        });
    });
</script>

<script>
    function previewProfileImage(input) {
        if (input.files && input.files[0]) {
            const reader = new FileReader();
            reader.onload = e => document.getElementById('profilePreview').src = e.target.result;
            reader.readAsDataURL(input.files[0]);
        }
    }
</script>
@endsection