@extends('layouts.admin')
@section('title', 'Student Management')
@section('content')
 
<div class="dashboard-content bg-light p-4 mt-5">
    <div class="content-card rounded-2 bg-white p-4 mt-lg-4 mt-md-4 mt-1">
        {{-- <div class="row align-items-center">
            <div class="col-md-12">
                <p><a href="{{ route('admin.students.list') }}" class="text-dark text-decoration-none position-relative">
                    <i class="fa-solid fa-chevron-left me-2"></i> View Details</a>
                </p>
            </div>
        </div> --}}

        <div class="row rounded-4 border align-items-center mx-2 mt-lg-4 mt-md-2 mt-2 px-2 py-4 view-student-details-row">  
            {{-- <div class="col-md-2">
                <img src="{{ asset('img/edit-student.png') }}" alt="">
            </div> --}}

            <div class="col-md-2">
                <img src="{{ $student->avatar ? asset('storage/avatars/' . $student->avatar) : asset('img/no-image.png') }}" alt="Student Image" class="img-fluid rounded-circle">
            </div>

            <div class="col-md-5 px-0">
                <div class="table-responsive view-role-table view-student-table border-0 p-0">
                    <table class="table border-0 mb-0">
                        <tbody>
                            <tr>
                                <th class="py-1">Full Name:</th>
                                <td class="py-1">{{ $student->name ?? '-' }}</td>
                            </tr>
                            {{-- <tr>
                                <th class="py-1">Email address:</th>
                                <td class="py-1">{{ $student->email ?? '-' }} <i class="fa-solid fa-circle-check"></i></td>
                            </tr> --}}
                            <tr>
                                <th class="py-1">Email address:</th>
                                <td class="py-1">
                                    {{ $student->email ?? '-' }}
                                    @if($student->is_email_verified == '1')
                                        <i class="fa-solid fa-circle-check text-success" title="Verified"></i>
                                    @else
                                        <i class="fa-regular fa-circle-xmark text-danger" title="Not Verified"></i> {{$student->is_email_verified}}
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <th class="py-1">Date of Birth:</th>
                                <td class="py-1">{{ \Carbon\Carbon::parse($student->dob)->format('d/m/Y') ?? '-' }}</td>
                            </tr>
                            {{-- <tr>
                                <th class="py-1">Student Status:</th>
                                <td class="py-1">{{ $student->status == 1 ? 'Activated' : 'Inactive' }}</td>
                            </tr> --}}
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="col-md-5 px-0">
                <div class="table-responsive view-role-table view-student-table border-0 p-0">
                    <table class="table border-0 mb-0">
                        <tbody>
                            <tr>
                                <th class="py-1">Subscription Plan:</th>
                                <td class="py-1">
                                    {{ ($student->subscriptionPlan() != null && $student->subscriptionPlan()->stripe_subscription_id!='Free Trial') ?  'PAID' :'FREE' }}
                                </td>
                            </tr>
                            <tr>
                                <th class="py-1">Parent’s Name:</th>
                                <td class="py-1">{{ $student->parent_name ?? '-' }}</td> 
                            </tr>
                            <tr>
                                <th class="py-1">Parent’s Email ID:</th>
                                <td class="py-1">{{ $student->parent_email ?? '-' }}</i></td>
                            </tr>
                            <tr>
                                <th class="py-1">Report Frequency:</th>
                                <td class="py-1">{{ $student->report_frequency ?? 'Weekly' }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>


@endsection