@extends('layouts.admin')
@section('title', 'Subject Management')

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
@section('content')
<div class="dashboard-content bg-light p-4 mt-5">
    <div class="content-card rounded-2 bg-white p-4 mt-4">
        
        <div class="row mt-4">
            <div class="col-md-12">
                <form id="faqForm" class="add-user-form" action="{{ route('admin.subject.store') }}" method="POST" enctype="multipart/form-data">
                @csrf

                  <!-- <div class="row"> -->
                        <div class="col-md-12 text-center">
                            <p class="profile-icons position-relative d-inline-block">
                                <a href="#" class="text-decoration-none" onclick="event.preventDefault(); document.getElementById('imageInput').click();">
                                    <i class="fa-solid fa-circle-user fa-5x"></i>
                                    <span class="camera-icons rounded-circle d-flex justify-content-center align-items-center position-absolute bottom-0 end-0 shadow"
                                          style="width: 40px; height: 40px;">
                                        <i class="fa-solid fa-camera"></i>
                                    </span>
                                </a>
                    
                                <!-- Hidden file input -->
                                <input type="file" class="form-control d-none" name="icon" id="imageInput" accept="image/*">
                            </p>
                            <p class="text-danger error_container" id="error-icon"></p>

                        </div>
                    <!-- </div> -->

                    <div class="row mt-4">
                        <div class="col-md-6">
                            <label for="#" class="form-label">Name<span class="text-danger">*</span></label>
                            <input type="text" class="form-control rounded-2" id="f-name" placeholder="Enter Name" name="name">    
                             <p class="text-danger" id="error-name"></p>
                        </div>

                        <!-- <div class="col-md-6 mt-lg-0 mt-md-0 mt-4">
                            <div class="form-group">
                                <label class="form-label">Icon</label>
                                <div class="border edit-subject-file rounded-2 d-flex justify-content-between align-items-start">
                                    <input type="file" class="" name="icon">
                                </div>
                               
                            </div>
                        </div> -->

                         <!-- <div class="row mt-lg-4 mt-md-4 mt-2"> -->
                        <div class="col-md-6">
                            <label for="status" class="form-label">Status</label>
                            <select class="form-control rounded-2 form-select" name="status" id="status">
                                <option value="1">Active</option>
                                <option value="0">Inactive</option>
                            </select>
                        </div>
                        
                    <!-- </div> -->

                     
                    </div>
                  
                   
                   
                    <div class="row mt-5">
                        <div class="col-md-6">
                            <button type="submit" class="btn add-btn px-4 py-3 w-100 rounded-pill">Save</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>



<script>
    $(document).on('submit', 'form#faqForm', function(event) {
                        
        event.preventDefault();
        //clearing the error msg
        $('p.error_container').html("");

        var form = $(this);
        var formid = $(this).attr('id');

        var data = new FormData($(this)[0]);
        var url = form.attr("action");
        var loadingText = '<i class="fa fa-circle-o-notch fa-spin"></i> loading...';
        $('.submit').attr('disabled', true);
        $('.form-control').attr('readonly', true);
        $('.form-control').addClass('disabled-link');
        $('.error-control').addClass('disabled-link');
        if ($('.submit').html() !== loadingText) {
            $('.submit').html(loadingText);
        }
        $.ajax({
            type: form.attr('method'),
            url: url,
            data: data,
            cache: false,
            contentType: false,
            processData: false,
            success: function(response) {
                window.setTimeout(function() {
                    $('.submit').attr('disabled', false);
                    $('.form-control').attr('readonly', false);
                    $('.form-control').removeClass('disabled-link');
                    $('.error-control').removeClass('disabled-link');
                    $('.submit').html('Submit');
                }, 2000);
                //console.log(response);
                if (response.success === true) {
                    // Show server message in toastr
                    toastr.success(response.message);

                    // Redirect after 2 seconds
                    setTimeout(function () {
                        window.location.href = "{{ route('admin.subjects') }}";
                    }, 2000);
                }
                //show the form validates error
                if (response.success == false) {
                    for (control in response.errors) {
                        var error_text = control.replace('.', "_");
                        $('#'+formid+' #error-' + error_text).html(response.errors[control]);
                        // $('#error-'+error_text).html(response.errors[error_text][0]);
                        // console.log('#error-'+error_text);
                    }
                    // console.log(response.errors);
                }
            },
            error: function(response) {
                // alert("Error: " + errorThrown);
                console.log(response);
            }
        });
        event.stopImmediatePropagation();
        return false;
    });
</script>

@endsection